/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.SocketScriptConsoleIO;

public class ScriptConsoleServer
implements Runnable {
    public static final int DEFAULT_PORT = 25000;
    private static ScriptConsoleServer instance;
    private final int port;
    private final Map handlers;

    public static ScriptConsoleServer getInstance() {
        if (instance == null) {
            instance = new ScriptConsoleServer(25000);
        }
        return instance;
    }

    protected ScriptConsoleServer(int port) {
        this.port = port;
        this.handlers = new HashMap();
        new Thread(this).start();
    }

    public String register(ConsoleRequest request) {
        String id = new Long(System.currentTimeMillis()).toString();
        this.register(id, request);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id, ConsoleRequest request) {
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.put(id, request);
            this.handlers.notifyAll();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(this.port);
            while (true) {
                final Socket client = server.accept();
                Thread clientHandler = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SocketScriptConsoleIO proxy = new SocketScriptConsoleIO(client);
                            String id = proxy.getId();
                            ConsoleRequest request = null;
                            Map map = ScriptConsoleServer.this.handlers;
                            synchronized (map) {
                                request = (ConsoleRequest)ScriptConsoleServer.this.handlers.get(id);
                                while (request == null) {
                                    try {
                                        ScriptConsoleServer.this.handlers.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                ScriptConsoleServer.this.handlers.remove(id);
                            }
                            request.consoleConnected(proxy);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                clientHandler.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

