/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.commands.DbgpStackCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.debug.dbgp.tests.DbgpProtocolTests;
import org.w3c.dom.Element;

public class DbgpStackCommandsTests
extends DbgpProtocolTests {
    protected Element getStackDepthResponse(int transaction_id, int depth) throws IOException {
        String xml = this.getResourceAsString("get_stack_depth.xml");
        xml = MessageFormat.format(xml, Integer.toString(transaction_id), Integer.toString(depth));
        return this.parseResponse(xml);
    }

    protected Element getStackLevelsResponse() {
        return null;
    }

    public void testStackDepth() throws Exception {
        final Element response = this.getStackDepthResponse(324, 3);
        DbgpStackCommands commands = new DbgpStackCommands(new IDbgpCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpStackCommandsTests.assertEquals((int)1, (int)request.optionCount());
                DbgpStackCommandsTests.assertTrue((boolean)request.hasOption("-i"));
                DbgpStackCommandsTests.assertEquals((String)Integer.toString(324), (String)request.getOption("-i"));
                return response;
            }

            public void send(DbgpRequest request) throws DbgpException {
            }
        });
        int depth = commands.getStackDepth();
        DbgpStackCommandsTests.assertEquals((int)3, (int)depth);
    }

    public void testGetStackLevel() throws Exception {
        final Element response = null;
        DbgpStackCommands commands = new DbgpStackCommands(new IDbgpCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpStackCommandsTests.assertEquals((int)2, (int)request.optionCount());
                DbgpStackCommandsTests.assertTrue((boolean)request.hasOption("-i"));
                DbgpStackCommandsTests.assertTrue((boolean)request.hasOption("-d"));
                DbgpStackCommandsTests.assertEquals((String)Integer.toString(2), (String)request.getOption("-d"));
                return response;
            }

            public void send(DbgpRequest request) throws DbgpException {
            }
        });
        IDbgpStackLevel level = commands.getStackLevel(2);
        DbgpStackCommandsTests.assertEquals((int)2, (int)level.getLevel());
    }

    public void testGetStackLevels() throws Exception {
    }
}

