/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.launching.debug;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.launching.DebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.debug.RubyDebugPlugin;

public class RubyBasicDebuggerRunner
extends DebuggingEngineRunner {
    private static final String RUBY_HOST_VAR = "DBGP_RUBY_HOST";
    private static final String RUBY_PORT_VAR = "DBGP_RUBY_PORT";
    private static final String RUBY_KEY_VAR = "DBGP_RUBY_KEY";
    private static final String RUBY_SCRIPT_VAR = "DBGP_RUBY_SCRIPT";
    private static final String RUBY_LOG_VAR = "DBGP_RUBY_LOG";
    private static final String DEBUGGER_DBGP_DIR = "dbgp";
    private static final String DEBUGGER_SCRIPT = "runner.rb";
    private final boolean logging;

    protected String getLogFilename() {
        return RubyDebugPlugin.getDefault().getStateLocation().append("debug_log.txt").toOSString();
    }

    protected IPath deploy() throws CoreException {
        try {
            return RubyDebugPlugin.getDefault().deployDebuggerSource();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.debug", "Can't deploy debugger source", (Throwable)e));
        }
    }

    public RubyBasicDebuggerRunner(IInterpreterInstall install) {
        super(install);
        this.logging = true;
    }

    protected InterpreterConfig alterConfig(String exe, InterpreterConfig config) throws CoreException {
        IPath sourceLocation = this.deploy();
        File scriptFile = sourceLocation.append(DEBUGGER_DBGP_DIR).append(DEBUGGER_SCRIPT).toFile();
        String includePath = sourceLocation.toOSString();
        InterpreterConfig newConfig = new InterpreterConfig();
        newConfig.addInterpreterArgs(config.getInterpreterArgs());
        newConfig.addInterpreterArg("-I" + includePath);
        newConfig.setScriptFile(scriptFile);
        newConfig.addScriptArgs(config.getScriptArgs());
        newConfig.setWorkingDirectory(config.getWorkingDirectory());
        String host = (String)config.getProperty("host");
        String port = (String)config.getProperty("port");
        String sessionId = (String)config.getProperty("sessionId");
        newConfig.addEnvVars(config.getEnvVars());
        newConfig.addEnvVar(RUBY_HOST_VAR, host);
        newConfig.addEnvVar(RUBY_PORT_VAR, port);
        newConfig.addEnvVar(RUBY_KEY_VAR, sessionId);
        newConfig.addEnvVar(RUBY_SCRIPT_VAR, config.getScriptFile().toString());
        if (this.logging) {
            newConfig.addEnvVar(RUBY_LOG_VAR, this.getLogFilename());
        }
        return newConfig;
    }
}

