/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class CallLocation
implements IAdaptable {
    public static final int UNKNOWN_LINE_NUMBER = -1;
    private IModelElement fMember;
    private IModelElement fCalledMember;
    private int fStart;
    private int fEnd;
    private String fCallText;
    private int fLineNumber;
    static /* synthetic */ Class class$0;

    public CallLocation(IModelElement member, IModelElement calledMember, int start, int end, int lineNumber) {
        this.fMember = member;
        this.fCalledMember = calledMember;
        this.fStart = start;
        this.fEnd = end;
        this.fLineNumber = lineNumber;
    }

    public IModelElement getCalledMember() {
        return this.fCalledMember;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public IModelElement getMember() {
        return this.fMember;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLineNumber() {
        this.initCallTextAndLineNumber();
        return this.fLineNumber;
    }

    public String getCallText() {
        this.initCallTextAndLineNumber();
        return this.fCallText;
    }

    private void initCallTextAndLineNumber() {
        if (this.fCallText != null) {
            return;
        }
        IBuffer buffer = this.getBufferForMember();
        if (buffer == null || buffer.getLength() < this.fEnd) {
            this.fCallText = "";
            this.fLineNumber = -1;
            return;
        }
        this.fCallText = buffer.getText(this.fStart, this.fEnd - this.fStart);
        if (this.fLineNumber == -1) {
            Document document = new Document(buffer.getContents());
            try {
                this.fLineNumber = document.getLineOfOffset(this.fStart) + 1;
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    private IBuffer getBufferForMember() {
        IBuffer buffer = null;
        try {
            IOpenable openable = this.fMember.getOpenable();
            if (openable != null && this.fMember.exists()) {
                buffer = openable.getBuffer();
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return buffer;
    }

    public String toString() {
        return this.getCallText();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(adapter)) {
            return this.getMember();
        }
        return null;
    }
}

