/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerProblemsDecorator;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class ScriptExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private ScriptExplorerContentProvider fContentProvider;
    private boolean fIsFlatLayout;
    private ScriptExplorerProblemsDecorator fProblemDecorator = new ScriptExplorerProblemsDecorator();

    public ScriptExplorerLabelProvider(long textFlags, int imageFlags, ScriptExplorerContentProvider cp, IPreferenceStore store) {
        super(textFlags, imageFlags, store);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
    }

    public String getText(Object element) {
        if (this.fIsFlatLayout || !(element instanceof IScriptFolder)) {
            return super.getText(element);
        }
        IScriptFolder fragment = (IScriptFolder)element;
        if (fragment.isRootFolder()) {
            return super.getText(fragment);
        }
        Object parent = this.fContentProvider.getScriptFolderProvider().getParent(fragment);
        if (parent instanceof IScriptFolder) {
            return this.getNameDelta((IScriptFolder)parent, fragment);
        }
        if (parent instanceof IFolder) {
            int prefixLength = this.getPrefixLength((IFolder)parent);
            return fragment.getElementName().substring(prefixLength);
        }
        return super.getText(fragment);
    }

    private int getPrefixLength(IFolder folder) {
        Object parent = this.fContentProvider.getParent(folder);
        int folderNameLenght = folder.getName().length() + 1;
        if (parent instanceof IScriptFolder) {
            String fragmentName = ((IScriptFolder)parent).getElementName();
            return fragmentName.length() + 1 + folderNameLenght;
        }
        if (parent instanceof IFolder) {
            return this.getPrefixLength((IFolder)parent) + folderNameLenght;
        }
        return folderNameLenght;
    }

    private String getNameDelta(IScriptFolder topFragment, IScriptFolder bottomFragment) {
        String bottomName;
        String topName = topFragment.getElementName();
        if (topName.equals(bottomName = bottomFragment.getElementName())) {
            return topName;
        }
        String deltaname = bottomName;
        if (deltaname.startsWith(topName) && bottomName.length() >= topName.length() + 1) {
            deltaname = bottomName.substring(topName.length() + 1);
        }
        return deltaname;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }
}

