/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IDbgpThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.IScriptDebugTargetStreamManager;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointManager;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptThreadManager;

public class ScriptDebugTarget
extends ScriptDebugElement
implements IScriptDebugTarget,
IDbgpThreadManagerListener {
    private static final int THREAD_TERMINATION_TIMEOUT = 5000;
    private final ListenerList listeners;
    private IScriptDebugTargetStreamManager manager;
    private final IProcess process;
    private final ILaunch launch;
    private String name;
    private boolean disconnected;
    private final ScriptThreadManager threadManager;
    private final ScriptBreakpointManager breakpointManager;
    private final IDbgpService dbgpService;
    private final String dbgpId;
    private final String mondelId;
    private URI scriptUri;
    private int scriptNonEmptyLine = -1;

    /*
     * Exception decompiling
     */
    private static int findFirstNonEmptyScriptLine(IFile file) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 99->102)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupScriptParameters(ILaunchConfiguration configuration) throws CoreException {
        String scriptName;
        String projectName = configuration.getAttribute("project", null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IResource resource = project.findMember(scriptName = configuration.getAttribute("mainScript", null));
        if (resource instanceof IFile) {
            this.scriptUri = ScriptLineBreakpoint.makeUri((IResource)((IFile)resource));
            this.scriptNonEmptyLine = ScriptDebugTarget.findFirstNonEmptyScriptLine((IFile)resource);
        }
    }

    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String id, ILaunch launch, IProcess process) throws CoreException {
        this.setupScriptParameters(launch.getLaunchConfiguration());
        this.mondelId = modelId;
        this.listeners = new ListenerList();
        this.process = process;
        this.launch = launch;
        this.threadManager = new ScriptThreadManager(this);
        this.dbgpId = id;
        this.dbgpService = dbgpService;
        this.dbgpService.registerAcceptor(this.dbgpId, this.threadManager);
        this.disconnected = false;
        this.breakpointManager = new ScriptBreakpointManager(this);
        this.threadManager.addListener(this);
        DebugEventHelper.fireCreateEvent(this);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getModelIdentifier() {
        return this.mondelId;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public boolean hasThreads() throws DebugException {
        return this.threadManager.hasThreads();
    }

    public IThread[] getThreads() throws DebugException {
        return this.threadManager.getThreads();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean canTerminate() {
        return this.threadManager.canTerminate();
    }

    public boolean isTerminated() {
        return this.threadManager.isTerminated();
    }

    protected boolean waitTermianted() {
        int all = 0;
        while (all < 5000) {
            try {
                Thread.sleep(400L);
                all += 400;
            }
            catch (InterruptedException interruptedException) {}
            if (!this.threadManager.isTerminated()) continue;
            return true;
        }
        return false;
    }

    public void terminate() throws DebugException {
        this.dbgpService.unregisterAcceptor(this.dbgpId);
        this.dbgpService.shutdown();
        this.threadManager.terminate();
        if (this.waitTermianted()) {
            this.threadManager.removeListener(this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            DebugEventHelper.fireTerminateEvent(this);
        }
    }

    public boolean canSuspend() {
        return this.threadManager.canSuspend();
    }

    public boolean isSuspended() {
        return this.threadManager.isSuspended();
    }

    public void suspend() throws DebugException {
        this.threadManager.suspend();
    }

    public boolean canResume() {
        return this.threadManager.canResume();
    }

    public void resume() throws DebugException {
        this.threadManager.resume();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IScriptVariable findVariable(String variableName) throws DebugException {
        return null;
    }

    public int getRequestTimeout() {
        return 0;
    }

    public void setRequestTimeout(int timeout) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointManager.breakpointAdded(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointChanged(breakpoint, delta);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointRemoved(breakpoint, delta);
    }

    public IScriptDebugTargetStreamManager getStreamManager() {
        return this.manager;
    }

    public void setStreamManager(IScriptDebugTargetStreamManager manager) {
        this.manager = manager;
    }

    public void threadAccepted(IScriptThread thread, boolean first) {
        if (first) {
            Preferences prefs = DLTKDebugPlugin.getDefault().getPluginPreferences();
            boolean breakOnFirstLine = prefs.getBoolean("dbgp_break_on_first_line");
            if (breakOnFirstLine && this.scriptUri != null && this.scriptNonEmptyLine != -1) {
                this.breakpointManager.setBreakpointUntilFirstSuspend(this.scriptUri, this.scriptNonEmptyLine);
            }
            this.breakpointManager.setupDeferredBreakpoints();
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            this.fireTargetInitialized();
        }
    }

    public void allThreadsTerminated() {
        try {
            this.terminate();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Debugging engine (id = " + this.dbgpId + ")";
    }

    public void runToLine(URI uri, int lineNumber) throws DebugException {
        this.breakpointManager.setBreakpointUntilFirstSuspend(uri, lineNumber);
        this.resume();
    }

    public boolean isInitialized() {
        return !this.threadManager.isWaitingForThreads();
    }

    protected void fireTargetInitialized() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptDebugTargetListener)list[i]).targetInitialized();
            ++i;
        }
    }

    public void addListener(IScriptDebugTargetListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IScriptDebugTargetListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.breakpointManager.supportsBreakpoint(breakpoint);
    }
}

