/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyCallArgument
extends ASTNode {
    public static final int SIMPLE = 0;
    public static final int VARARG = 1;
    public static final int BLOCK = 2;
    private ASTNode value;
    private int kind;

    public ASTNode getValue() {
        return this.value;
    }

    public void setValue(ASTNode value) {
        this.value = value;
    }

    public RubyCallArgument(ASTNode value) {
        super(value.sourceStart(), value.sourceEnd());
        this.value = value;
    }

    public RubyCallArgument(ASTNode value, int kind) {
        super(value.sourceStart(), value.sourceEnd());
        this.value = value;
        this.kind = kind;
    }

    public int getArgumentKind() {
        return this.kind;
    }

    public int getKind() {
        return 0;
    }

    public void printNode(CorePrinter output) {
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.getValue() != null) {
                this.getValue().traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyCallArgument)) {
            return false;
        }
        RubyCallArgument arg = (RubyCallArgument)((Object)obj);
        return arg.kind == this.kind && arg.value == this.value;
    }
}

