/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.codeassist;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.text.RubyKeyword;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.IMixinSearchRequestor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.jruby.util.collections.WeakHashSet;

public class RubyCompletionEngine
extends ScriptCompletionEngine {
    private static final int RELEVANCE_FREE_SPACE = 10000000;
    private static final int RELEVANCE_KEYWORD = 1000000;
    private static final int RELEVANCE_METHODS = 100000;
    private static final String[] globalVars = new String[]{"$DEBUG", "$$", "$-i", "$deferr", "$/", "$'", "$stdout", "$-l", "$-I", "$.", "$KCODE", "$binding", "$-w", "$FILENAME", "$defout", "$,", "$`", "$-F", "$*", "$LOADED_FEATURES", "$stdin", "$-p", "$:", "$\\", "$=", "$!", "$-v", "$>", "$&", "$;", "$SAFE", "$PROGRAM_NAME", "$\"", "$-d", "$?", "$-0", "$+", "$@", "$-a", "$VERBOSE", "$stderr", "$~", "$0", "$LOAD_PATH", "$<", "$_", "$-K"};
    private DLTKTypeInferenceEngine inferencer;
    private ISourceParser parser = null;
    private MixinModel model;
    private HashSet completedNames = new HashSet();
    private WeakHashSet intresting = new WeakHashSet();
    private ASTNode completionNode;
    private final Comparator modelElementComparator = new Comparator(){
        Collator collator = Collator.getInstance(Locale.ENGLISH);

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof IModelElement && arg1 instanceof IModelElement) {
                IModelElement me1 = (IModelElement)arg1;
                IModelElement me2 = (IModelElement)arg0;
                int r = -this.collator.compare(me1.getElementName(), me2.getElementName());
                if (r == 0) {
                    boolean cur2;
                    boolean cur1 = me1.getAncestor(5).equals(RubyCompletionEngine.this.currentModule);
                    if (cur1 == (cur2 = me2.getAncestor(5).equals(RubyCompletionEngine.this.currentModule))) {
                        return 0;
                    }
                    return cur1 ? -1 : 1;
                }
                return r;
            }
            return 0;
        }
    };
    private ISourceModule currentModule;

    public RubyCompletionEngine() {
        this.inferencer = new DLTKTypeInferenceEngine();
        this.model = RubyMixinModel.getRawInstance();
        try {
            this.parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed to initialize RubyCompletionEngine", e);
        }
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return null;
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        return null;
    }

    private boolean afterColons(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == ':' && content.charAt(position - 2) == ':';
    }

    private boolean afterDollar(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '$';
    }

    private boolean afterAt(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '@';
    }

    private boolean afterAt2(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == '@' && content.charAt(position - 2) == '@';
    }

    private String getWordStarting(String content, int position, int maxLen) {
        int original = position;
        if (position <= 0) {
            return "";
        }
        if (position >= content.length()) {
            position = content.length();
        }
        --position;
        int len = 0;
        while (position >= 0 && len < maxLen && RubySyntaxUtils.isLessStrictIdentifierCharacter(content.charAt(position))) {
            --position;
        }
        if (position + 1 > original) {
            return "";
        }
        if (position >= 0 && Character.isWhitespace(content.charAt(position)) || position == -1) {
            return content.substring(position + 1, original);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete(ISourceModule module, int position, int i) {
        this.currentModule = module;
        if (Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0) {
            this.requestor.completionFailure((IProblem)new DefaultProblem(null, "Please wait until building is ready...", 0, null, 2, this.startPosition, this.endPosition, -1));
            return;
        }
        if (!RubyPlugin.initialized) {
            this.requestor.completionFailure((IProblem)new DefaultProblem(null, "Please wait while DLTK Ruby being initialized...", 0, null, 2, this.startPosition, this.endPosition, -1));
            return;
        }
        this.completedNames.clear();
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        org.eclipse.dltk.core.ISourceModule modelModule = (org.eclipse.dltk.core.ISourceModule)module;
        try {
            String content = module.getSourceContents();
            String wordStarting = this.getWordStarting(content, position, 10);
            if (wordStarting != null) {
                this.setSourceRange(position - wordStarting.length(), position);
                String[] keywords = RubyKeyword.findByPrefix(wordStarting);
                int j = 0;
                while (j < keywords.length) {
                    this.reportKeyword(keywords[j]);
                    ++j;
                }
            }
            ModuleDeclaration moduleDeclaration = this.parser.parse(module.getFileName(), content.toCharArray(), null);
            if (this.afterDollar(content, position)) {
                this.completeGlobalVar((org.eclipse.dltk.core.ISourceModule)module, moduleDeclaration, "$", position);
            } else if (this.afterAt2(content, position)) {
                this.completeSimpleRef((org.eclipse.dltk.core.ISourceModule)module, moduleDeclaration, "@@", position);
            } else if (this.afterAt(content, position)) {
                this.completeSimpleRef((org.eclipse.dltk.core.ISourceModule)module, moduleDeclaration, "@", position);
            } else if (this.afterColons(content, position)) {
                ASTNode node = ASTUtils.findMaximalNodeEndingAt(moduleDeclaration, position - 2);
                this.setSourceRange(position, position);
                if (node != null) {
                    BasicContext basicContext = new BasicContext(modelModule, moduleDeclaration);
                    ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)basicContext, node);
                    IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
                    this.reportSubElements(modelModule, type, "");
                } else {
                    this.completeConstant(modelModule, moduleDeclaration, "", position, true);
                }
            } else {
                ASTNode minimalNode = ASTUtils.findMinimalNode(moduleDeclaration, position, position);
                if (minimalNode != null) {
                    this.completionNode = minimalNode;
                    if (minimalNode instanceof CallExpression) {
                        this.completeCall(modelModule, moduleDeclaration, (CallExpression)minimalNode, position);
                    } else if (minimalNode instanceof ConstantReference) {
                        this.completeConstant(modelModule, moduleDeclaration, (ConstantReference)minimalNode, position);
                    } else if (minimalNode instanceof RubyColonExpression) {
                        this.completeColonExpression(modelModule, moduleDeclaration, (RubyColonExpression)minimalNode, position);
                    } else if (minimalNode instanceof SimpleReference) {
                        this.completeSimpleRef(modelModule, moduleDeclaration, ((SimpleReference)minimalNode).getName(), position);
                    } else if (minimalNode instanceof RubyDVarExpression) {
                        this.completeSimpleRef(modelModule, moduleDeclaration, ((RubyDVarExpression)minimalNode).getName(), position);
                    } else if (wordStarting == null || wordStarting.length() == 0) {
                        int rel = 10000000;
                        try {
                            IModelElement[] children = modelModule.getChildren();
                            if (children != null) {
                                int j = 0;
                                while (j < children.length) {
                                    IMethod method;
                                    if (children[j] instanceof IField) {
                                        this.reportField((IField)children[j], rel);
                                    }
                                    if (children[j] instanceof IMethod && ((method = (IMethod)children[j]).getFlags() & 0x80) == 0) {
                                        this.reportMethod(method, rel);
                                    }
                                    if (children[j] instanceof IType && !children[j].getElementName().trim().startsWith("<<")) {
                                        this.reportType((IType)children[j], rel);
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            Object var13_21 = null;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            this.requestor.endReporting();
            throw throwable;
        }
        this.requestor.endReporting();
    }

    private void completeClassMethods(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration moduleDeclaration, RubyMixinClass rubyClass, String prefix) {
        CompletionMixinMethodRequestor mixinSearchRequestor = new CompletionMixinMethodRequestor(rubyClass);
        rubyClass.findMethods(prefix, true, mixinSearchRequestor);
        mixinSearchRequestor.flush();
    }

    private void completeClassMethods(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration moduleDeclaration, IEvaluatedType type, String prefix) {
        if (type instanceof RubyClassType) {
            RubyClassType rubyClassType = (RubyClassType)type;
            RubyMixinClass rubyClass = RubyMixinModel.getInstance().createRubyClass(rubyClassType);
            if (rubyClass != null) {
                this.completeClassMethods(modelModule, moduleDeclaration, rubyClass, prefix);
            }
        } else if (type instanceof AmbiguousType) {
            AmbiguousType type2 = (AmbiguousType)type;
            IEvaluatedType[] possibleTypes = type2.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                this.completeClassMethods(modelModule, moduleDeclaration, possibleTypes[i], prefix);
                ++i;
            }
        }
    }

    private void completeClassMethods(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration moduleDeclaration, ASTNode receiver, String pattern) {
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(modelModule, moduleDeclaration), receiver);
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 2000);
        this.completeClassMethods(modelModule, moduleDeclaration, type, pattern);
    }

    private void completeGlobalVar(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, String prefix, int position) {
        int relevance = 424242;
        this.setSourceRange(position - prefix.length(), position);
        IMixinElement[] elements = RubyMixinModel.getRawInstance().find(String.valueOf(prefix) + "*");
        int i = 0;
        while (i < elements.length) {
            IRubyMixinElement rubyElement = RubyMixinModel.getInstance().createRubyElement(elements[i]);
            if (rubyElement instanceof RubyMixinVariable) {
                RubyMixinVariable variable = (RubyMixinVariable)rubyElement;
                IField[] sourceFields = variable.getSourceFields();
                int j = 0;
                while (j < sourceFields.length) {
                    if (sourceFields[j] != null) {
                        this.reportField(sourceFields[j], relevance--);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < globalVars.length) {
            if (globalVars[i].startsWith(prefix)) {
                this.reportField((IField)new FakeField((ModelElement)module, globalVars[i], 0, 0), relevance--);
            }
            ++i;
        }
    }

    private void completeSimpleRef(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, String prefix, int position) {
        int relevance = 424242;
        this.setSourceRange(position - prefix.length(), position);
        ASTNode[] wayToNode = ASTUtils.restoreWayToNode(moduleDeclaration, this.completionNode);
        int i = wayToNode.length - 1;
        while (i > 0) {
            if (wayToNode[i] instanceof RubyBlock) {
                RubyBlock rubyBlock = (RubyBlock)wayToNode[i];
                Set vars = rubyBlock.getVars();
                Iterator iterator = vars.iterator();
                while (iterator.hasNext()) {
                    RubyDAssgnExpression rd;
                    ASTNode n = (ASTNode)iterator.next();
                    if (!(n instanceof RubyDAssgnExpression) || !(rd = (RubyDAssgnExpression)n).getName().startsWith(prefix)) continue;
                    this.reportField((IField)new FakeField((ModelElement)module, rd.getName(), 0, 0), relevance--);
                }
            }
            --i;
        }
        if (prefix.startsWith("$")) {
            this.completeGlobalVar(module, moduleDeclaration, prefix, position);
        } else {
            IField[] fields = RubyModelUtils.findFields(module, moduleDeclaration, prefix, position);
            int i2 = 0;
            while (i2 < fields.length) {
                this.reportField(fields[i2], relevance--);
                ++i2;
            }
        }
    }

    private void reportSubElements(org.eclipse.dltk.core.ISourceModule module, IEvaluatedType type, String prefix) {
        IField t;
        RubyClassType rubyClassType;
        IMixinElement mixinElement;
        int relevance = 424242;
        ArrayList<IType> types = new ArrayList<IType>();
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        ArrayList<IField> fields = new ArrayList<IField>();
        if (type instanceof RubyClassType && (mixinElement = this.model.get((rubyClassType = (RubyClassType)type).getModelKey())) != null) {
            IMixinElement[] children = mixinElement.getChildren();
            int i = 0;
            while (i < children.length) {
                Object[] infos = children[i].getAllObjects();
                int j = 0;
                while (j < infos.length) {
                    RubyMixinElementInfo obj = (RubyMixinElementInfo)infos[j];
                    if (obj.getObject() != null) {
                        IField fff;
                        IMethod method2;
                        if (obj.getKind() == 0 || obj.getKind() == 1) {
                            IType type2 = (IType)obj.getObject();
                            if (type2 != null && type2.getElementName().startsWith(prefix)) {
                                types.add(type2);
                            }
                        } else if (obj.getKind() == 2 && (method2 = (IMethod)obj.getObject()) != null && method2.getElementName().startsWith(prefix)) {
                            methods.add(method2);
                        }
                        if (obj.getKind() != 3 || (fff = (IField)obj.getObject()) == null || !fff.getElementName().startsWith(prefix)) break;
                        fields.add(fff);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        Collections.sort(fields, this.modelElementComparator);
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            t = (IField)iterator.next();
            this.reportField(t, relevance--);
        }
        Collections.sort(types, this.modelElementComparator);
        iterator = types.iterator();
        while (iterator.hasNext()) {
            t = (IType)iterator.next();
            this.reportType((IType)t, relevance--);
        }
        Collections.sort(methods, this.modelElementComparator);
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            t = (IMethod)iterator.next();
            this.reportMethod((IMethod)t, relevance--);
        }
    }

    private void completeColonExpression(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, RubyColonExpression node, int position) {
        String content;
        try {
            content = module.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = node.getLeft() != null ? node.getLeft().sourceEnd() + 2 : node.sourceStart();
        String starting = null;
        try {
            starting = content.substring(pos, position).trim();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
        if (starting.startsWith("::")) {
            this.setSourceRange(position - starting.length() + 2, position);
            this.completeConstant(module, moduleDeclaration, starting.substring(2), position, true);
            return;
        }
        this.setSourceRange(position - starting.length(), position);
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(module, moduleDeclaration), node.getLeft());
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
        this.reportSubElements(module, type, starting);
    }

    private void completeConstant(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, String prefix, int position, boolean topLevelOnly) {
        if (!topLevelOnly) {
            IMixinElement[] modelStaticScopes = RubyTypeInferencingUtils.getModelStaticScopes(this.model, moduleDeclaration, position);
            int i = modelStaticScopes.length - 1;
            while (i >= 0) {
                IMixinElement scope = modelStaticScopes[i];
                if (scope != null) {
                    this.reportSubElements(module, (IEvaluatedType)new RubyClassType(scope.getKey()), prefix);
                }
                --i;
            }
        }
        int relevance = 4242;
        if (prefix.length() > 0) {
            String varkey = "Object{" + prefix;
            RubyMixinModel rubyModel = RubyMixinModel.getInstance();
            String[] keys2 = rubyModel.getRawModel().findKeys(String.valueOf(varkey) + "*");
            int i = 0;
            while (i < keys2.length) {
                IRubyMixinElement element = rubyModel.createRubyElement(keys2[i]);
                if (element instanceof RubyMixinVariable) {
                    RubyMixinVariable variable = (RubyMixinVariable)element;
                    IField[] sourceFields = variable.getSourceFields();
                    int j = 0;
                    while (j < sourceFields.length) {
                        if (sourceFields[j] != null) {
                            this.reportField(sourceFields[j], relevance--);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        HashSet<String> names = new HashSet<String>();
        IType[] allTypes = RubyTypeInferencingUtils.getAllTypes(module, prefix);
        int i = 0;
        while (i < allTypes.length) {
            String elementName = allTypes[i].getElementName();
            if (!names.contains(elementName)) {
                names.add(elementName);
                this.reportType(allTypes[i], relevance--);
            }
            ++i;
        }
    }

    private void completeConstant(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, ConstantReference node, int position) {
        String content;
        try {
            content = module.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        String prefix = content.substring(node.sourceStart(), position);
        this.setSourceRange(position - prefix.length(), position);
        this.completeConstant(module, moduleDeclaration, prefix, position, false);
    }

    private void completeCall(org.eclipse.dltk.core.ISourceModule module, ModuleDeclaration moduleDeclaration, CallExpression node, int position) {
        String content;
        ASTNode receiver = node.getReceiver();
        try {
            content = module.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = receiver != null ? receiver.sourceEnd() + 1 : node.sourceStart();
        int t = 0;
        while (t < 2) {
            if (pos < position && !RubySyntaxUtils.isStrictIdentifierCharacter(content.charAt(pos))) {
                ++pos;
            }
            ++t;
        }
        String starting = content.substring(pos, position).trim();
        if (receiver == null) {
            this.completeSimpleRef(module, moduleDeclaration, starting, position);
        }
        this.setSourceRange(position - starting.length(), position);
        if (starting.startsWith("__")) {
            String[] keywords = RubyKeyword.findByPrefix("__");
            int j = 0;
            while (j < keywords.length) {
                this.reportKeyword(keywords[j]);
                ++j;
            }
        }
        if (receiver != null) {
            this.completeClassMethods(module, moduleDeclaration, receiver, starting);
        } else {
            RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(module, moduleDeclaration, position);
            this.completeClassMethods(module, moduleDeclaration, (IEvaluatedType)self, starting);
        }
    }

    protected String processFieldName(IField field, String token) {
        return field.getElementName();
    }

    private void reportMethod(IMethod method, int rel) {
        char[] name;
        this.intresting.add(method);
        String elementName = method.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        if (elementName.indexOf(46) != -1) {
            elementName = elementName.substring(elementName.indexOf(46) + 1);
        }
        char[] compl = name = elementName.toCharArray();
        int relevance = rel;
        this.noProposal = false;
        if (!this.requestor.isIgnored(6)) {
            CompletionProposal proposal = this.createProposal(6, this.actualCompletionPosition);
            String[] params = null;
            try {
                params = method.getParameters();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            if (params != null && params.length > 0) {
                char[][] args = new char[params.length][];
                int i = 0;
                while (i < params.length) {
                    args[i] = params[i].toCharArray();
                    ++i;
                }
                proposal.setParameterNames((char[][])args);
            }
            proposal.setModelElement((IModelElement)method);
            proposal.setName(name);
            proposal.setCompletion(compl);
            try {
                proposal.setFlags(method.getFlags());
            }
            catch (ModelException e) {
                RubyPlugin.log((Exception)((Object)e));
            }
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportType(IType type, int rel) {
        this.intresting.add(type);
        String elementName = type.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        char[] name = elementName.toCharArray();
        if (name.length == 0) {
            return;
        }
        int relevance = rel;
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)type);
            proposal.setName(name);
            proposal.setCompletion(elementName.toCharArray());
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException modelException) {}
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportField(IField field, int rel) {
        this.intresting.add(field);
        String elementName = field.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        char[] name = elementName.toCharArray();
        if (name.length == 0) {
            return;
        }
        int relevance = rel;
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)field);
            proposal.setName(name);
            proposal.setCompletion(elementName.toCharArray());
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportKeyword(String name) {
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(name.toCharArray());
            proposal.setCompletion(name.toCharArray());
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(1000000);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private class CompletionMixinMethodRequestor
    implements IMixinSearchRequestor {
        private String lastParent = null;
        private List group = new ArrayList();
        private int relevance = 0;
        private final RubyMixinClass klass;

        public CompletionMixinMethodRequestor(RubyMixinClass klass) {
            this.klass = klass;
        }

        public void acceptResult(IRubyMixinElement element) {
            if (element instanceof RubyMixinMethod) {
                RubyMixinMethod method = (RubyMixinMethod)element;
                String parent = method.getSelfType().getKey();
                if (this.lastParent == null || !this.lastParent.equals(parent)) {
                    this.flush();
                    this.lastParent = parent;
                }
                this.group.add(method);
            }
        }

        public void flush() {
            if (this.group.size() > 0) {
                RubyMixinMethod[] mixinMethods = this.group.toArray(new RubyMixinMethod[this.group.size()]);
                List allSourceMethods = RubyModelUtils.getAllSourceMethods(mixinMethods, this.klass);
                IMethod[] methods = allSourceMethods.toArray(new IMethod[allSourceMethods.size()]);
                Arrays.sort(methods, RubyCompletionEngine.this.modelElementComparator);
                int j = 0;
                while (j < methods.length) {
                    RubyCompletionEngine.this.reportMethod(methods[j], 100000 + this.relevance);
                    ++j;
                }
                this.group.clear();
            }
            --this.relevance;
        }
    }
}

