/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.builder.IScriptBuilder;

public class ScriptBuilderManager {
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.core.builder";
    private static final String NATURE_ATTR = "nature";
    private static Map builders;

    private static void initialize() {
        if (builders != null) {
            return;
        }
        builders = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTPOINT);
        int i = 0;
        while (i < cfg.length) {
            List<IConfigurationElement> elements;
            String nature = cfg[i].getAttribute(NATURE_ATTR);
            if (builders.get(nature) != null) {
                elements = (List)builders.get(nature);
                elements.add(cfg[i]);
            } else {
                elements = new ArrayList();
                elements.add(cfg[i]);
                builders.put(nature, elements);
            }
            ++i;
        }
    }

    public static IScriptBuilder[] getScriptBuilders(String natureId) throws CoreException {
        ScriptBuilderManager.initialize();
        ArrayList results = new ArrayList();
        ScriptBuilderManager.processNature(natureId, results);
        ScriptBuilderManager.processNature("#", results);
        return results.toArray(new IScriptBuilder[results.size()]);
    }

    private static void processNature(String natureId, List results) throws CoreException {
        block7: {
            Object ext;
            block8: {
                ext = builders.get(natureId);
                if (ext == null) break block7;
                if (!(ext instanceof IScriptBuilder[])) break block8;
                IScriptBuilder[] b = (IScriptBuilder[])ext;
                int i = 0;
                while (i < b.length) {
                    if (!results.contains(b[i])) {
                        results.add(b[i]);
                    }
                    ++i;
                }
                break block7;
            }
            if (!(ext instanceof List)) break block7;
            List elements = (List)ext;
            IScriptBuilder[] result = new IScriptBuilder[elements.size()];
            int i = 0;
            while (i < elements.size()) {
                Object e = elements.get(i);
                if (e instanceof IScriptBuilder) {
                    result[i] = (IScriptBuilder)e;
                } else {
                    IScriptBuilder builder;
                    IConfigurationElement cfg = (IConfigurationElement)e;
                    result[i] = builder = (IScriptBuilder)cfg.createExecutableExtension("class");
                }
                ++i;
            }
            builders.put(natureId, result);
            i = 0;
            while (i < result.length) {
                if (!results.contains(result[i])) {
                    results.add(result[i]);
                }
                ++i;
            }
        }
    }

    public static IScriptBuilder[] getAllScriptBuilders() throws CoreException {
        ScriptBuilderManager.initialize();
        ArrayList<IScriptBuilder> result = new ArrayList<IScriptBuilder>();
        Iterator iterator = builders.keySet().iterator();
        while (iterator.hasNext()) {
            String nature = (String)iterator.next();
            IScriptBuilder[] b = ScriptBuilderManager.getScriptBuilders(nature);
            int i = 0;
            while (i < b.length) {
                result.add(b[i]);
                ++i;
            }
        }
        return result.toArray(new IScriptBuilder[result.size()]);
    }
}

