/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;

public abstract class DebuggingEngineRunner
extends AbstractInterpreterRunner {
    protected static final int DEFAULT_WAITING_TIMEOUT = 1000000;
    protected static final int DEFAULT_PAUSE = 500;

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.launching";
    }

    protected String generateSessionId() {
        return "dbgp" + System.currentTimeMillis();
    }

    protected String getSessionId(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("dbgp_session_id", null);
        if (id == null) {
            id = this.generateSessionId();
        }
        return id;
    }

    protected void addDebugTarget(ILaunch launch, ILaunchConfiguration configuration, IDbgpService dbgpService, String sessionId) throws CoreException {
        ScriptDebugTarget target = new ScriptDebugTarget(this.getDebugModelId(), dbgpService, sessionId, launch, null);
        launch.addDebugTarget((IDebugTarget)target);
    }

    public DebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    protected IDbgpService createDebuggingService(ILaunchConfiguration configuration) throws CoreException {
        try {
            int port = configuration.getAttribute("dbpg_port", -1);
            if (port == -1) {
                return DLTKDebugPlugin.getDefault().createDbgpService();
            }
            return DLTKDebugPlugin.getDefault().creaeDbgpService(port);
        }
        catch (Exception exception) {
            this.abort("org.eclipse.dltk.launching", "Dbgp service not available", null, 200);
            return null;
        }
    }

    protected InterpreterConfig alterConfig(String exe, InterpreterConfig config) throws CoreException {
        return config;
    }

    protected void initialize(InterpreterConfig config, ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        IDbgpService service = this.createDebuggingService(configuration);
        String sessionId = this.getSessionId(configuration);
        this.addDebugTarget(launch, configuration, service, sessionId);
        int port = service.getPort();
        config.setProperty("host", "127.0.0.1");
        config.setProperty("port", Integer.toString(port));
        config.setProperty("sessionId", sessionId);
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        try {
            ILaunchConfiguration configuration = launch.getLaunchConfiguration();
            this.initialize(config, launch, configuration);
            InterpreterConfig newConfig = this.alterConfig(this.constructProgramString(), config);
            DebuggingEngineRunner.sleep(500L);
            try {
                String exe = (String)newConfig.getProperty("OVERRIDE_EXE");
                if (exe != null) {
                    String[] cmdLine = newConfig.renderCommandLine(exe);
                    this.rawRun(launch, cmdLine, newConfig.getWorkingDirectory(), newConfig.getEnvironmentAsStrings());
                } else {
                    super.run(newConfig, launch, monitor);
                }
            }
            catch (CoreException coreException) {
                this.abort("org.eclipse.dltk.launching", "Debugging engine not started", null, 201);
            }
            int waitingTimeout = configuration.getAttribute("dbpg_waiting_timeout", 1000000);
            ScriptDebugTargetWaiter waiter = new ScriptDebugTargetWaiter((IScriptDebugTarget)launch.getDebugTarget());
            if (!waiter.waitThread(waitingTimeout)) {
                this.abort("org.eclipse.dltk.launching", "Debugging engine not connected", null, 202);
            }
        }
        catch (CoreException e) {
            launch.terminate();
            throw e;
        }
    }

    protected String getDebugModelId() {
        return ScriptDebugManager.getInstance().getDebugModelByNature(this.getInstall().getNatureId());
    }

    public static class ScriptDebugTargetWaiter
    implements IScriptDebugTargetListener {
        private IScriptDebugTarget target;

        public ScriptDebugTargetWaiter(IScriptDebugTarget target) {
            if (target == null) {
                throw new IllegalArgumentException();
            }
            this.target = target;
        }

        public synchronized void targetInitialized() {
            this.notifyAll();
        }

        public synchronized boolean waitThread(int timeout) {
            this.target.addListener((IScriptDebugTargetListener)this);
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
            this.target.removeListener((IScriptDebugTargetListener)this);
            return this.target.isInitialized();
        }
    }
}

