/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.WorkingCopyManager;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.text.completion.ContentAssistHistory;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.dltk.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class DLTKUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.ui";
    public static final String ID_SCRIPTEXPLORER = "org.eclipse.dltk.ui.ScriptExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.dltk.ui.TypeHierarchy";
    private static DLTKUIPlugin plugin;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private ContentAssistHistory fContentAssistHistory;
    private IWorkingCopyManager fWorkingCopyManager;
    private ISourceModuleDocumentProvider fSourceModuleDocumentProvider;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private EditorTextHoverDescriptor[] fEditorTextHoverDescriptors;
    static /* synthetic */ Class class$0;

    public DLTKUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null) {
                    if (resource instanceof IFile) {
                        return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                    }
                } else if (original instanceof ExternalSourceModule) {
                    IPath path = original.getPath();
                    return new DocumentAdapter((IOpenable)workingCopy, path);
                }
                if (original instanceof BuiltinSourceModule) {
                    IPath path = original.getPath();
                    return new DocumentAdapter((IOpenable)workingCopy, path);
                }
                return DocumentAdapter.NULL;
            }
        });
        IPreferenceStore store = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(store);
        DLTKLaunchingPlugin.getDefault();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fMembersOrderPreferenceCache != null) {
            this.fMembersOrderPreferenceCache.dispose();
            this.fMembersOrderPreferenceCache = null;
        }
        super.stop(context);
        plugin = null;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static DLTKUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActivePage() {
        return DLTKUIPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DLTKUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ISourceModuleDocumentProvider provider = this.getSourceModuleDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ISourceModuleDocumentProvider getSourceModuleDocumentProvider() {
        if (this.fSourceModuleDocumentProvider == null) {
            this.fSourceModuleDocumentProvider = new SourceModuleDocumentProvider();
        }
        return this.fSourceModuleDocumentProvider;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DLTKUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static IModelElement getEditorInputModelElement(IEditorInput editorInput) {
        ISourceModule je = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (je != null) {
            return je;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IModelElement)editorInput.getAdapter((Class)clazz);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        DLTKUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, DLTKUIMessages.ScriptPlugin_internal_error, e));
    }

    public static void logErrorMessage(String message) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            DLTKUIPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        DLTKUIPlugin.log((IStatus)multi);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DLTKUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public ContentAssistHistory getContentAssistHistory() {
        if (this.fContentAssistHistory == null) {
            try {
                this.fContentAssistHistory = ContentAssistHistory.load(this.getPluginPreferences(), "content_assist_lru_history");
            }
            catch (CoreException x) {
                DLTKUIPlugin.log(x);
            }
            if (this.fContentAssistHistory == null) {
                this.fContentAssistHistory = new ContentAssistHistory();
            }
        }
        return this.fContentAssistHistory;
    }

    public void resetEditorTextHoverDescriptors() {
        this.fEditorTextHoverDescriptors = null;
    }

    public EditorTextHoverDescriptor[] getEditorTextHoverDescriptors(IPreferenceStore store) {
        if (this.fEditorTextHoverDescriptors == null) {
            this.fEditorTextHoverDescriptors = EditorTextHoverDescriptor.getContributedHovers(store);
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((EditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fEditorTextHoverDescriptors);
        }
        return this.fEditorTextHoverDescriptors;
    }

    public static IEditorPart openInEditor(IModelElement element) throws ModelException, PartInitException {
        return DLTKUIPlugin.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(IModelElement element, boolean activate, boolean reveal) throws ModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public static boolean isDebug() {
        return DLTKCore.DEBUG;
    }
}

