/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.visitors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.BooleanLiteral;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;

public class RubyAttributeHandler {
    private static final String ATTR = "attr";
    private static final String ATTR_ACCESSOR = "attr_accessor";
    private static final String ATTR_WRITER = "attr_writer";
    private static final String ATTR_READER = "attr_reader";
    private final CallExpression call;
    private List readers;
    private List writers;

    public RubyAttributeHandler(CallExpression call) {
        if (!RubyAttributeHandler.isAttributeCreationCall(call)) {
            throw new IllegalArgumentException();
        }
        this.call = call;
        this.readers = new ArrayList();
        this.writers = new ArrayList();
        this.init();
    }

    private void init() {
        String name = this.call.getName();
        CallArgumentsList list = this.call.getArgs();
        List expr = list.getChilds();
        Iterator it = expr.iterator();
        boolean create_reader = false;
        boolean create_writer = false;
        if (name.equals(ATTR_READER)) {
            create_reader = true;
        } else if (name.equals(ATTR_WRITER)) {
            create_writer = true;
        } else if (name.equals(ATTR_ACCESSOR)) {
            create_reader = true;
            create_writer = true;
        } else if (name.equals(ATTR)) {
            create_reader = true;
            if (expr.size() > 0) {
                ASTNode node = (ASTNode)expr.get(expr.size() - 1);
                if (node instanceof RubyCallArgument) {
                    node = ((RubyCallArgument)node).getValue();
                }
                if (node instanceof BooleanLiteral) {
                    BooleanLiteral lit = (BooleanLiteral)node;
                    create_writer = lit.boolValue();
                }
            }
        }
        while (it.hasNext()) {
            String attr;
            ASTNode sr = (ASTNode)it.next();
            if (!(sr instanceof RubyCallArgument) || (attr = RubyAttributeHandler.getText(sr = ((RubyCallArgument)sr).getValue())) == null) continue;
            if (create_reader) {
                this.readers.add(sr);
            }
            if (!create_writer) continue;
            this.writers.add(sr);
        }
    }

    public List getReaders() {
        return this.readers;
    }

    public List getWriters() {
        return this.writers;
    }

    public static boolean isAttributeCreationCall(CallExpression c) {
        if (c.getReceiver() != null) {
            return false;
        }
        String name = c.getName();
        return name.equals(ATTR_READER) || name.equals(ATTR_WRITER) || name.equals(ATTR_ACCESSOR) || name.equals(ATTR);
    }

    public static String getText(ASTNode sr) {
        if (sr == null) {
            return null;
        }
        String attr = null;
        if (sr instanceof RubySymbolReference) {
            attr = ((RubySymbolReference)sr).getName();
        } else if (sr instanceof StringLiteral) {
            attr = ((StringLiteral)sr).getValue();
        }
        return attr;
    }
}

