/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.internal.ui.RubyPreferenceConstants;
import org.eclipse.dltk.ruby.ui.tests.internal.TestUtils;
import org.eclipse.dltk.ui.text.blocks.Balance;
import org.eclipse.dltk.ui.text.blocks.BlocksConfiguration;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.IRangeFilter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class BalanceTest
extends SuiteOfTestCases {
    IPreferenceStore fStore;

    public BalanceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fStore = new PreferenceStore();
        RubyPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public Balance doTest(String data, BlocksConfiguration blocks, String expected) throws Exception {
        Document doc = new Document(data);
        TestUtils.installStuff(doc);
        Balance b = Balance.calculateBalance((IDocument)doc, (int)0, (int)doc.getLength(), (BlocksConfiguration)blocks, (IRangeFilter)TestUtils.ALL_RANGES_ALLOWED, null);
        BalanceTest.assertEquals((String)expected, (String)b.toDebugString((IDocument)doc));
        return b;
    }

    public void doBackwardMultilineTest(String data, BlocksConfiguration blocks) throws Exception {
        Document doc = new Document(data);
        TestUtils.installStuff(doc);
        Balance prev = null;
        int lineIndex = doc.getNumberOfLines() - 1;
        while (lineIndex >= 0) {
            String sumExpected = null;
            String lineExpected = null;
            int lineStart = doc.getLineOffset(lineIndex);
            int lineLength = doc.getLineLength(lineIndex);
            String line = doc.get(lineStart, lineLength);
            int eol = TextUtilities.indexOf((String[])doc.getLegalLineDelimiters(), (String)line, (int)0)[0];
            int pos = line.indexOf("###");
            if (pos >= 0) {
                sumExpected = line.substring(pos + 3).trim();
                doc.replace(lineStart + pos, eol - pos, AutoEditUtils.getNSpaces((int)(eol - pos)));
                Assert.isTrue((lineLength == doc.getLineLength(lineIndex) ? 1 : 0) != 0);
                line = doc.get(lineStart, lineLength);
            }
            eol = TextUtilities.indexOf((String[])doc.getLegalLineDelimiters(), (String)line, (int)0)[0];
            pos = line.indexOf("##");
            if (pos >= 0) {
                lineExpected = line.substring(pos + 2).trim();
                doc.replace(lineStart + pos, eol - pos, AutoEditUtils.getNSpaces((int)(eol - pos)));
                Assert.isTrue((lineLength == doc.getLineLength(lineIndex) ? 1 : 0) != 0);
            }
            Balance b = Balance.calculateBalance((IDocument)doc, (int)lineStart, (int)lineLength, (BlocksConfiguration)blocks, (IRangeFilter)TestUtils.ALL_RANGES_ALLOWED, null);
            if (lineExpected != null) {
                BalanceTest.assertEquals((String)("Line balance mismatch processing line#" + lineIndex + ": " + line), (String)lineExpected, (String)b.toDebugString((IDocument)doc));
            }
            if (prev != null) {
                b.addAll(prev, null);
            }
            if (sumExpected != null) {
                BalanceTest.assertEquals((String)("Combined balance mismatch processing line#" + lineIndex + ": " + line), (String)sumExpected, (String)b.toDebugString((IDocument)doc));
            }
            prev = b;
            --lineIndex;
        }
    }

    public void testEmpty() throws Exception {
        this.doTest("", TestUtils.ALL_RUBY_BLOCKS, "");
    }

    public void testOpenIf() throws Exception {
        this.doTest("if foo", TestUtils.ALL_RUBY_BLOCKS, "if");
    }

    public void testNonStatementIf() throws Exception {
        this.doTest("foo if bar", TestUtils.ALL_RUBY_BLOCKS, "");
    }

    public void testSingleLineIf() throws Exception {
        this.doTest("if foo then bar end", TestUtils.ALL_RUBY_BLOCKS, "");
    }

    public void testNestedIfInExpression() throws Exception {
        this.doTest("if 10 + if foo then 20 else 30 end", TestUtils.ALL_RUBY_BLOCKS, "if");
    }

    public void testSequentialIfs() throws Exception {
        this.doTest("if foo\nif bar\nif boz", TestUtils.ALL_RUBY_BLOCKS, "if if if");
    }

    public void testSemicolonSeparated() throws Exception {
        this.doTest("if foo; if bar; while boz", TestUtils.ALL_RUBY_BLOCKS, "if if while");
    }

    public void testDirectlyNested() throws Exception {
        this.doTest("if if bar then true else false end; puts 'x'", TestUtils.ALL_RUBY_BLOCKS, "if");
    }

    public void testDifferentStructures() throws Exception {
        this.doTest("module Boz\nif foo\nclass bar\ndef zzz\nend\nend", TestUtils.ALL_RUBY_BLOCKS, "module if");
    }

    public void testCombining1() throws Exception {
        this.doBackwardMultilineTest(TestUtils.getData("resources/balance1.rb"), TestUtils.ALL_RUBY_BLOCKS);
    }

    public void testCombining2() throws Exception {
        this.doBackwardMultilineTest(TestUtils.getData("resources/balance2.rb"), TestUtils.ALL_RUBY_BLOCKS);
    }
}

