/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorChangedListener;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.internal.core.CompositeId;
import org.eclipse.dltk.validators.internal.core.ListenerList;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.validators.internal.core.ValidatorManager;
import org.eclipse.dltk.validators.internal.core.ValidatorsCore;

public final class ValidatorRuntime {
    public static final String PREF_VALIDATOR_XML = "org.eclipse.dltk.validators.core.PREF_VALIDATOR_XML";
    public static final String MARKER_VALIDATOR = "org.eclipse.dltk.validators.core.marker_validator_id";
    private static Object fgValidatorLock = new Object();
    private static boolean fgInitializingValidators = false;
    private static ListenerList fgValidatorListeners = new ListenerList(5);
    private static Set fgContributedValidators = new HashSet();
    public static IProcessAction processValidate = new IProcessAction(){

        public IStatus execute(IValidator validator, ISourceModule[] o, OutputStream out, IProgressMonitor monitor) {
            if (monitor != null) {
                monitor.beginTask("Validating", o.length);
            }
            int i = 0;
            while (i < o.length) {
                validator.validate(o[i], out);
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus execute(IValidator validator, IResource[] o, OutputStream out, IProgressMonitor monitor) {
            if (monitor != null) {
                monitor.beginTask("Validating", o.length);
            }
            int i = 0;
            while (i < o.length) {
                validator.validate(o[i], out);
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    };
    public static IProcessAction processClean = new IProcessAction(){

        public IStatus execute(IValidator validator, ISourceModule[] o, OutputStream out, IProgressMonitor monitor) {
            if (monitor != null) {
                monitor.beginTask("Validating", o.length);
            }
            int i = 0;
            while (i < o.length) {
                validator.clean(o[i]);
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (monitor != null) {
                monitor.done();
            }
            return null;
        }

        public IStatus execute(IValidator validator, IResource[] o, OutputStream out, IProgressMonitor monitor) {
            if (monitor != null) {
                monitor.beginTask("Validating", o.length);
            }
            int i = 0;
            while (i < o.length) {
                validator.clean(o[i]);
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (monitor != null) {
                monitor.done();
            }
            return null;
        }
    };

    private ValidatorRuntime() {
    }

    public static IValidatorType getValidatorType(String id) {
        IValidatorType[] interpreterTypes = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < interpreterTypes.length) {
            if (interpreterTypes[i].getID().equals(id)) {
                return interpreterTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static IValidatorType[] getValidatorTypes() {
        ValidatorRuntime.initializeValidators();
        try {
            return ValidatorManager.getAllValidatorTypes();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IValidatorType[] getValidatorTypes(String nature) {
        try {
            return ValidatorManager.getValidators(nature);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCompositeIdFromValidator(IValidator validator) {
        if (validator == null) {
            return null;
        }
        IValidatorType validatorType = validator.getValidatorType();
        String typeID = validatorType.getID();
        CompositeId id = new CompositeId(new String[]{typeID, validator.getID()});
        return id.toString();
    }

    public static IValidator getValidatorFromCompositeId(String idString) {
        IValidatorType validatorType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (validatorType = ValidatorRuntime.getValidatorType(id.get(0))) != null) {
            return validatorType.findValidator(id.get(1));
        }
        return null;
    }

    public static void saveInterpreterConfiguration() throws CoreException {
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        if (vals == null || vals.length == 0) {
            return;
        }
        try {
            String xml = ValidatorRuntime.getValidatorsAsXML();
            ValidatorRuntime.getPreferences().setValue(PREF_VALIDATOR_XML, xml);
            ValidatorRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "Error", 4, "Exception occured", (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "Error", 4, "Exception occured", (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "Error", 4, "Exception occured", (Throwable)e));
        }
    }

    private static String getValidatorsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        IValidatorType[] validatorTypes = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < validatorTypes.length) {
            IValidator[] Interpreters = validatorTypes[i].getValidators();
            int j = 0;
            while (j < Interpreters.length) {
                IValidator install = Interpreters[j];
                container.addValidator(install);
                ++j;
            }
            ++i;
        }
        return container.getAsXML();
    }

    private static boolean addPersistedValidators(ValidatorDefinitionsContainer interpreterDefs) throws IOException {
        String validatorXMLString = ValidatorRuntime.getPreferences().getString(PREF_VALIDATOR_XML);
        if (validatorXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(validatorXMLString.getBytes("UTF-8"));
                ValidatorDefinitionsContainer.parseXMLIntoContainer(inputStream, interpreterDefs);
                return false;
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static boolean isContributedValidator(String id) {
        ValidatorRuntime.getValidatorTypes();
        return fgContributedValidators.contains(id);
    }

    public static Preferences getPreferences() {
        return ValidatorsCore.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        ValidatorsCore.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeValidators() {
        ValidatorDefinitionsContainer validatorDefs = null;
        boolean setPref = false;
        Object object = fgValidatorLock;
        synchronized (object) {
            try {
                fgInitializingValidators = true;
                try {
                    validatorDefs = new ValidatorDefinitionsContainer();
                    setPref = ValidatorRuntime.addPersistedValidators(validatorDefs);
                }
                catch (IOException iOException) {}
                Object var3_6 = null;
                fgInitializingValidators = false;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                fgInitializingValidators = false;
                throw throwable;
            }
        }
        if (validatorDefs == null) return;
        IValidatorType[] validatorTypes = null;
        try {
            validatorTypes = ValidatorManager.getAllValidatorTypes();
        }
        catch (CoreException coreException) {
            return;
        }
        int i = 0;
        while (i < validatorTypes.length) {
            IValidatorType type = validatorTypes[i];
            IValidator[] installs = type.getValidators();
            if (installs != null) {
                int j = 0;
                while (j < installs.length) {
                    ValidatorRuntime.fireInterpreterAdded(installs[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (!setPref) return;
        try {
            String xml = validatorDefs.getAsXML();
            ValidatorRuntime.getPreferences().setValue(PREF_VALIDATOR_XML, xml);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (TransformerException transformerException) {}
    }

    public static void addValidatorChangedListener(IValidatorChangedListener listener) {
        fgValidatorListeners.add(listener);
    }

    public static void removeValidatorInstallChangedListener(IValidatorChangedListener listener) {
        fgValidatorListeners.remove(listener);
    }

    public static void fireValidatorChanged(IValidator validator) {
        Object[] listeners = fgValidatorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IValidatorChangedListener listener = (IValidatorChangedListener)listeners[i];
            listener.validatorChanged(validator);
            ++i;
        }
    }

    public static void fireInterpreterAdded(IValidator Interpreter) {
        if (!fgInitializingValidators) {
            Object[] listeners = fgValidatorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IValidatorChangedListener listener = (IValidatorChangedListener)listeners[i];
                listener.validatorAdded(Interpreter);
                ++i;
            }
        }
    }

    public static void fireInterpreterRemoved(IValidator Interpreter) {
        Object[] listeners = fgValidatorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IValidatorChangedListener listener = (IValidatorChangedListener)listeners[i];
            listener.validatorRemoved(Interpreter);
            ++i;
        }
    }

    public static IValidatorType[] getPossibleValidatorTypes() {
        ArrayList<IValidatorType> possible = new ArrayList<IValidatorType>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            if (!vals[i].isBuiltin()) {
                possible.add(vals[i]);
            }
            ++i;
        }
        return possible.toArray(new IValidatorType[possible.size()]);
    }

    public static IValidator[] getActiveValidators() {
        ArrayList<IValidator> possible = new ArrayList<IValidator>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            IValidator[] v = vals[i].getValidators();
            int j = 0;
            while (j < v.length) {
                if (v[j].isActive() && v[j].isValidatorValid() && !possible.contains(v[j])) {
                    possible.add(v[j]);
                }
                ++j;
            }
            ++i;
        }
        return possible.toArray(new IValidator[possible.size()]);
    }

    public static IValidator[] getValidValidators() {
        ArrayList<IValidator> possible = new ArrayList<IValidator>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            IValidator[] v = vals[i].getValidators();
            int j = 0;
            while (j < v.length) {
                if (v[j].isValidatorValid() && !possible.contains(v[j])) {
                    possible.add(v[j]);
                }
                ++j;
            }
            ++i;
        }
        return possible.toArray(new IValidator[possible.size()]);
    }

    public static IValidator[] getAllValidators() {
        ArrayList<IValidator> possible = new ArrayList<IValidator>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            IValidator[] v = vals[i].getValidators();
            int j = 0;
            while (j < v.length) {
                if (!possible.contains(v[j])) {
                    possible.add(v[j]);
                }
                ++j;
            }
            ++i;
        }
        return possible.toArray(new IValidator[possible.size()]);
    }

    public static void executeActiveValidators(OutputStream stream, List elements, List resources, IProgressMonitor monitor) {
        IValidator[] activeValidators = ValidatorRuntime.getActiveValidators();
        ValidatorRuntime.process(stream, elements, resources, activeValidators, processValidate, monitor);
    }

    public static void executeActiveValidators(OutputStream stream, List elements, List resources) {
        ValidatorRuntime.executeActiveValidators(stream, elements, resources, null);
    }

    public static void executeAllValidators(OutputStream stream, List elements, List resources, IProgressMonitor monitor) {
        IValidator[] activeValidators = ValidatorRuntime.getValidValidators();
        ValidatorRuntime.process(stream, elements, resources, activeValidators, processValidate, monitor);
    }

    public static void executeValidator(String id, OutputStream stream, List elements, List resources, IProgressMonitor monitor) {
        IValidator[] validValidators = ValidatorRuntime.getValidValidators();
        ArrayList<IValidator> required = new ArrayList<IValidator>();
        int i = 0;
        while (i < validValidators.length) {
            if (id.equals(validValidators[i].getValidatorType().getID())) {
                required.add(validValidators[i]);
            }
            ++i;
        }
        IValidator[] activeValidators = required.toArray(new IValidator[required.size()]);
        if (activeValidators.length == 0) {
            block7: {
                if (stream != null) {
                    try {
                        IValidatorType type = ValidatorRuntime.getValidatorType(id);
                        String sub = "...";
                        if (type != null) {
                            sub = "for " + type.getName() + "...";
                        }
                        stream.write(("Validation could not be performed...\nPlease check validator preferences " + sub).getBytes());
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block7;
                        e.printStackTrace();
                    }
                }
            }
            return;
        }
        ValidatorRuntime.process(stream, elements, resources, required.toArray(new IValidator[required.size()]), processValidate, monitor);
    }

    public static void executeAllValidators(OutputStream stream, List elements, List resources) {
        ValidatorRuntime.executeAllValidators(stream, elements, resources, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void process(OutputStream stream, List elements, List resources, IValidator[] activeValidators, IProcessAction action, IProgressMonitor monitor) {
        block6: {
            block7: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Running validators", activeValidators.length * 100);
                try {
                    if (elements == null) break block6;
                    int i = 0;
                    while (i < activeValidators.length) {
                        ISourceModule[] modules = ValidatorRuntime.filterModulesForValidator(elements, activeValidators[i], monitor);
                        if (monitor.isCanceled()) {
                            Object var9_9 = null;
                            break block7;
                        }
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                        action.execute(activeValidators[i], modules, stream, (IProgressMonitor)subMonitor);
                        ++i;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var9_11 = null;
        monitor.done();
    }

    private static ISourceModule[] filterModulesForValidator(List elements, IValidator v, IProgressMonitor monitor) {
        ArrayList<ISourceModule> result = new ArrayList<ISourceModule>();
        String nature = v.getValidatorType().getNature();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IDLTKLanguageToolkit toolkit;
            ISourceModule module;
            block4: {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                IModelElement el = (IModelElement)iterator.next();
                if (!(el instanceof ISourceModule)) continue;
                module = (ISourceModule)el;
                toolkit = null;
                try {
                    toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            if ((toolkit == null || !toolkit.getNatureId().equals(nature)) && !nature.equals("#")) continue;
            result.add(module);
        }
        return result.toArray(new ISourceModule[result.size()]);
    }

    public static void executeCleanAllValidatorsWithConsole(List elements, List resources) {
        ValidatorRuntime.executeCleanAllValidatorsWithConsole(elements, resources);
    }

    public static void executeCleanAllValidatorsWithConsole(List elements, List resources, IProgressMonitor monitor) {
        IValidator[] activeValidators = ValidatorRuntime.getAllValidators();
        ValidatorRuntime.process(null, elements, resources, activeValidators, processClean, monitor);
    }

    private static interface IProcessAction {
        public IStatus execute(IValidator var1, ISourceModule[] var2, OutputStream var3, IProgressMonitor var4);

        public IStatus execute(IValidator var1, IResource[] var2, OutputStream var3, IProgressMonitor var4);
    }
}

