/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.MoveResourceElementsOperation;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.Messages;

public class RenameResourceElementsOperation
extends MoveResourceElementsOperation {
    public RenameResourceElementsOperation(IModelElement[] elements, IModelElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    protected String getMainTaskName() {
        return Messages.operation_renameResourceProgress;
    }

    protected boolean isRename() {
        return true;
    }

    protected void verify(IModelElement element) throws ModelException {
        SourceModule cu;
        super.verify(element);
        int elementType = element.getElementType();
        if (elementType != 5 && elementType != 4) {
            this.error(967, element);
        }
        if (elementType == 5 && (cu = (SourceModule)element).isWorkingCopy() && !cu.isPrimary()) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

