/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalProjectFragmentInfo;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ExternalScriptFolderInfo;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;

public class ExternalProjectFragment
extends ProjectFragment {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath fPath;
    protected final boolean fReadOnly;
    protected final boolean fOnlyScriptResources;

    protected ExternalProjectFragment(IPath path, ScriptProject project, boolean isReadOnly, boolean onlyScriptResources) {
        super(null, project);
        this.fPath = path;
        this.fReadOnly = isReadOnly;
        this.fOnlyScriptResources = onlyScriptResources;
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        char[][] exclusionPatterns;
        ArrayList vChildren = new ArrayList(5);
        ArrayList vForeign = new ArrayList(5);
        char[][] inclusionPatterns = this.fullInclusionPatternChars();
        this.computeFolderChildren(this.fPath, !Util.isExcluded(this.fPath, inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars(), true), vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeFolderChildren(IPath path, boolean isIncluded, ArrayList vChildren, ArrayList vForeign, Map newElements, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        IPath lpath = path.removeFirstSegments(this.fPath.segmentCount());
        ExternalScriptFolder fldr = (ExternalScriptFolder)this.getScriptFolder(lpath);
        boolean valid = Util.isValidSourcePackageName(this, path);
        if ((lpath.segmentCount() == 0 || valid) && isIncluded) {
            vChildren.add(fldr);
        } else {
            if (this.fOnlyScriptResources) {
                return;
            }
            if (!valid) {
                return;
            }
        }
        ArrayList<IPath> scriptElements = new ArrayList<IPath>();
        ArrayList<IPath> nonScriptElements = new ArrayList<IPath>();
        try {
            File file = new File(path.toOSString());
            String[] members = file.list();
            if (members != null) {
                int i = 0;
                int max = members.length;
                while (i < max) {
                    String member = members[i];
                    IPath memberPath = path.append(member);
                    File memberFile = new File(memberPath.toOSString());
                    if (memberFile.isDirectory()) {
                        boolean isMemberIncluded = !Util.isExcluded(memberPath, inclusionPatterns, exclusionPatterns, true);
                        this.computeFolderChildren(memberPath, isMemberIncluded, vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns);
                    } else if (Util.isValidSourceModule((IModelElement)this, memberPath)) {
                        scriptElements.add(memberPath);
                    } else if (!this.fOnlyScriptResources || valid) {
                        nonScriptElements.add(memberPath);
                    }
                    ++i;
                }
            }
            ExternalScriptFolderInfo fragInfo = new ExternalScriptFolderInfo();
            fldr.computeChildren(fragInfo, scriptElements);
            fldr.computeForeignResources(fragInfo, nonScriptElements);
            newElements.put(fldr, fragInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public IScriptFolder getScriptFolder(IPath path) {
        block4: {
            try {
                ArrayList childs = this.getChildrenOfType(4);
                int i = 0;
                while (i < childs.size()) {
                    IScriptFolder folder = (IScriptFolder)childs.get(i);
                    if (folder.getElementName().equals(path.toPortableString())) {
                        return folder;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new ExternalScriptFolder(this, path);
    }

    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected Object createElementInfo() {
        return new ExternalProjectFragmentInfo();
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isExternal() {
        return true;
    }

    public IResource getUnderlyingResource() throws ModelException {
        return null;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.fPath;
        }
        return super.getPath();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.fPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            File file = new File(this.fPath.toOSString());
            return file.exists() && file.isDirectory();
        }
        return super.resourceExists();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public int getKind() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExternalProjectFragment) {
            ExternalProjectFragment other = (ExternalProjectFragment)o;
            return this.fPath.equals((Object)other.fPath);
        }
        return false;
    }

    public String getElementName() {
        return this.fPath.toOSString().replace(File.separatorChar, '>');
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }
}

