/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterContainer
implements IBuildpathContainer {
    private IInterpreterInstall fInterpreterInstall = null;
    private IPath fPath = null;
    private static Map fgBuildpathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IBuildpathEntry[] getBuildpathEntries(IInterpreterInstall interpreter) {
        IBuildpathEntry[] entries;
        if (fgBuildpathEntries == null) {
            fgBuildpathEntries = new HashMap(10);
            IInterpreterInstallChangedListener listener = new IInterpreterInstallChangedListener(){

                public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
                }

                public void interpreterChanged(PropertyChangeEvent event) {
                    if (event.getSource() != null) {
                        fgBuildpathEntries.remove(event.getSource());
                    }
                }

                public void interpreterAdded(IInterpreterInstall newInterpreter) {
                }

                public void interpreterRemoved(IInterpreterInstall removedInterpreter) {
                    fgBuildpathEntries.remove(removedInterpreter);
                }
            };
            ScriptRuntime.addInterpreterInstallChangedListener(listener);
        }
        if ((entries = (IBuildpathEntry[])fgBuildpathEntries.get(interpreter)) == null) {
            entries = InterpreterContainer.computeBuildpathEntries(interpreter);
            fgBuildpathEntries.put(interpreter, entries);
        }
        return entries;
    }

    private static IBuildpathEntry[] computeBuildpathEntries(IInterpreterInstall interpreter) {
        LibraryLocation[] libs = interpreter.getLibraryLocations();
        if (libs == null) {
            libs = ScriptRuntime.getLibraryLocations(interpreter);
        }
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(libs.length);
        ArrayList<IPath> rawEntries = new ArrayList<IPath>(libs.length);
        int i = 0;
        while (i < libs.length) {
            block11: {
                IPath entryPath = libs[i].getLibraryPath();
                if (!entryPath.isEmpty()) {
                    try {
                        File f = entryPath.toFile();
                        if (f == null) break block11;
                        entryPath = new Path(f.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        break block11;
                    }
                    if (!rawEntries.contains(entryPath)) {
                        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                        ArrayList<IPath> excluded = new ArrayList<IPath>();
                        int j = 0;
                        while (j < libs.length) {
                            block12: {
                                IPath otherPath = libs[j].getLibraryPath();
                                if (!otherPath.isEmpty()) {
                                    IPath pattern;
                                    try {
                                        File f = entryPath.toFile();
                                        if (f == null) break block12;
                                        entryPath = new Path(f.getCanonicalPath());
                                    }
                                    catch (IOException iOException) {
                                        break block12;
                                    }
                                    if (entryPath.isPrefixOf(otherPath) && !otherPath.equals((Object)entryPath) && !excluded.contains(pattern = otherPath.removeFirstSegments(entryPath.segmentCount()).append("*"))) {
                                        excluded.add(pattern);
                                    }
                                }
                            }
                            ++j;
                        }
                        entries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
                        rawEntries.add(entryPath);
                    }
                }
            }
            ++i;
        }
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        entries.add(DLTKCore.newBuiltinEntry((IPath)IBuildpathEntry.BUILTIN_EXTERNAL_ENTRY.append(interpreter.getInstallLocation().getAbsolutePath()), (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])new IPath[0], (boolean)false, (boolean)true));
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public InterpreterContainer(IInterpreterInstall interpreter, IPath path) {
        this.fInterpreterInstall = interpreter;
        this.fPath = path;
    }

    public IBuildpathEntry[] getBuildpathEntries() {
        return InterpreterContainer.getBuildpathEntries(this.fInterpreterInstall);
    }

    public String getDescription() {
        String tag = this.fInterpreterInstall.getName();
        return MessageFormat.format((String)LaunchingMessages.InterpreterEnvironmentContainer_InterpreterEnvironment_System_Library_1, (Object[])new String[]{tag});
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IBuiltinModuleProvider getBuiltinProvider() {
        return this.fInterpreterInstall;
    }
}

