/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class RubyPairMatcher
extends DefaultCharacterPairMatcher {
    private boolean fHighlightAngularBrackets = false;

    public RubyPairMatcher(char[] pairs) {
        super(pairs, "__ruby_partitioning");
    }

    public IRegion match(IDocument document, int offset) {
        try {
            return this.performMatch(document, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument document, int offset) throws BadLocationException {
        if (offset < 0 || document == null) {
            return null;
        }
        char prevChar = document.getChar(Math.max(offset - 1, 0));
        if (!(prevChar != '<' && prevChar != '>' || this.fHighlightAngularBrackets)) {
            return null;
        }
        if (prevChar == '<') {
            return null;
        }
        IRegion region = super.match(document, offset);
        if (region == null) {
            return region;
        }
        if (prevChar == '>') {
            region.getOffset();
            return null;
        }
        return region;
    }
}

