/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class JavaScriptBracketInserter
extends BracketInserter {
    JavaScriptBracketInserter(ScriptEditor scriptEditor) {
        super(scriptEditor);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ScriptEditor.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            ITypedRegion partition;
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            switch (event.character) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '<': {
                    if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                    return;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 2000 && prevToken != 2000 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"__javascript_partitioning", (int)offset, (boolean)true)).getType())) {
                return;
            }
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            char character = event.character;
            char closingCharacter = JavaScriptBracketInserter.getPeerCharacter((char)character);
            StringBuffer buffer = new StringBuffer();
            buffer.append(character);
            buffer.append(closingCharacter);
            document.replace(offset, length, buffer.toString());
            ScriptEditor.BracketLevel level = new ScriptEditor.BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            level.fOffset = offset;
            level.fLength = 2;
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            level.fFirstPosition = new Position(offset, 1);
            level.fSecondPosition = new Position(offset + 1, 1);
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
            level.fUI.setSimpleMode(true);
            LinkedModeUI linkedModeUI = level.fUI;
            ScriptEditor scriptEditor = this.editor;
            scriptEditor.getClass();
            linkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ScriptEditor.ExitPolicy(scriptEditor, closingCharacter, JavaScriptBracketInserter.getEscapeCharacter((char)closingCharacter), this.fBracketLevelStack));
            level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            IRegion newSelection = level.fUI.getSelectedRegion();
            sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = false;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }
}

