/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist.completion;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IClassReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.core.codeassist.AssitUtils;
import org.eclipse.dltk.javascript.internal.core.mixin.JavaScriptMixinModel;

public class JavaScriptCompletionEngine
extends ScriptCompletionEngine {
    private boolean useEngine = true;
    AssitUtils.PositionCalculator calculator;

    public boolean isUseEngine() {
        return this.useEngine;
    }

    public void setUseEngine(boolean useEngine) {
        this.useEngine = useEngine;
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        return null;
    }

    public void complete(ISourceModule cu, int position, int i) {
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        if (position > 0) {
            if (content.charAt(position - 1) == '.') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
            if (position > 0 && content.charAt(position - 1) == '=') {
                content = String.valueOf(content.substring(0, position)) + " \n\r e" + content.substring(position);
            }
        }
        this.calculator = new AssitUtils.PositionCalculator(content, position, false);
        char[] fileName2 = cu.getFileName();
        ReferenceResolverContext buildContext = AssitUtils.buildContext((org.eclipse.dltk.core.ISourceModule)cu, position, content, fileName2);
        HostCollection collection = buildContext.getHostCollection();
        String startPart = this.calculator.getCompletion();
        this.setSourceRange(position - startPart.length(), position);
        if (this.calculator.isMember()) {
            this.doCompletionOnMember(buildContext, cu, position, content, position, collection);
        } else {
            this.doGlobalCompletion(buildContext, cu, position, position, collection, startPart);
        }
        this.requestor.endReporting();
    }

    private void doGlobalCompletion(ReferenceResolverContext buildContext, ISourceModule cu, int position, int pos, HostCollection collection, String startPart) {
        Object name;
        Object next;
        Iterator<Object> it;
        HashSet<String> completedNames = new HashSet<String>();
        String completion = startPart;
        int k = completion.indexOf(91);
        while (k > 0) {
            int k1 = completion.indexOf(93);
            if (k1 == -1) {
                completion = completion.substring(k + 1);
            } else {
                String substring = completion.substring(0, k + 1);
                completion = String.valueOf(substring) + completion.substring(k1);
            }
            k = completion.indexOf(91);
            if (k != completion.length() - 1 && completion.charAt(k + 1) == ']') break;
        }
        char[] token = completion.toCharArray();
        if (this.useEngine) {
            this.doCompletionOnKeyword(position, pos, completion);
            JavaScriptMixinModel instance = JavaScriptMixinModel.getInstance();
            String[] findElements = instance.findElements("{" + completion);
            ArrayList<IModelElement> methods = new ArrayList<IModelElement>();
            ArrayList<char[]> fields = new ArrayList<char[]>();
            int a = 0;
            while (a < findElements.length) {
                Object[] allObjects;
                IMixinElement mixinElement;
                String string = findElements[a];
                if (string.lastIndexOf("{") <= 0 && (mixinElement = JavaScriptMixinModel.getRawInstance().get(string)) != null && (allObjects = mixinElement.getObjects(buildContext.getModule())).length > 0) {
                    int i = 0;
                    while (i < allObjects.length) {
                        String lastKeySegment;
                        Object object = allObjects[i];
                        if (object instanceof IModelElement) {
                            String elementName;
                            IModelElement el = (IModelElement)object;
                            int elementType = el.getElementType();
                            if (elementType == 9) {
                                methods.add(el);
                            } else if (elementType == 8 && !completedNames.contains(elementName = el.getElementName())) {
                                fields.add(elementName.toCharArray());
                                completedNames.add(elementName);
                            }
                        } else if (object == null && !completedNames.contains(lastKeySegment = mixinElement.getLastKeySegment())) {
                            fields.add(lastKeySegment.toCharArray());
                            completedNames.add(lastKeySegment);
                        }
                        ++i;
                    }
                }
                ++a;
            }
            this.findMethods(token, true, methods);
            char[][] choices = new char[fields.size()][];
            int a2 = 0;
            while (a2 < fields.size()) {
                choices[a2] = (char[])fields.get(a2);
                ++a2;
            }
            this.findLocalVariables(token, choices, true, false);
        }
        Map rfs = collection.getReferences();
        while (collection.getParent() != null) {
            collection = collection.getParent();
            Map m1 = collection.getReferences();
            it = m1.keySet().iterator();
            while (it.hasNext()) {
                String key;
                next = it.next();
                if (!(next instanceof String) || rfs.containsKey(key = (String)next)) continue;
                rfs.put(key, m1.get(key));
            }
        }
        HashMap names = new HashMap();
        it = rfs.keySet().iterator();
        while (it.hasNext()) {
            String name2;
            next = it.next();
            if (!(next instanceof String) || completedNames.contains(name2 = (String)next)) continue;
            names.put(name2, rfs.get(name2));
        }
        ReferenceResolverContext createResolverContext = buildContext;
        Set resolveGlobals = createResolverContext.resolveGlobals(completion);
        it = resolveGlobals.iterator();
        HashSet<IReference> classes = new HashSet<IReference>();
        HashSet<IReference> functions = new HashSet<IReference>();
        while (it.hasNext()) {
            IReference r;
            Object o = it.next();
            if (!(o instanceof IReference) || completedNames.contains((r = (IReference)o).getName())) continue;
            if (r instanceof IClassReference) {
                classes.add(r);
                continue;
            }
            if (r.isFunctionRef()) {
                functions.add(r);
                continue;
            }
            names.put(r.getName(), r);
        }
        names.remove("!!!returnValue");
        this.completeFromMap(position, completion, names);
        char[][] choices = new char[names.size()][];
        int ia = 0;
        Iterator<Object> iterator = names.keySet().iterator();
        while (iterator.hasNext()) {
            name = (String)iterator.next();
            choices[ia] = ((String)name).toCharArray();
            ++ia;
        }
        this.findLocalVariables(token, choices, true, false);
        choices = new char[classes.size()][];
        ia = 0;
        iterator = classes.iterator();
        while (iterator.hasNext()) {
            name = (IReference)iterator.next();
            choices[ia] = name.getName().toCharArray();
            ++ia;
        }
        this.findElements(token, choices, true, false, 7, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        choices = new char[functions.size()][];
        ia = 0;
        HashMap<char[], char[][]> parameterNames = new HashMap<char[], char[][]>();
        HashMap<char[], Object> proposalInfo = new HashMap<char[], Object>();
        Iterator iterator2 = functions.iterator();
        while (iterator2.hasNext()) {
            IReference name3 = (IReference)iterator2.next();
            choices[ia] = name3.getName().toCharArray();
            if (name3 instanceof UnknownReference) {
                parameterNames.put(choices[ia], ((UnknownReference)name3).getParameterNames());
                proposalInfo.put(choices[ia], ((UnknownReference)name3).getProposalInfo());
            }
            ++ia;
        }
        this.findElements(token, choices, true, false, 5, parameterNames, proposalInfo);
    }

    private void doCompletionOnMember(ReferenceResolverContext buildContext, ISourceModule cu, int position, String content, int pos, HostCollection collection) {
        String refa;
        IReference name;
        Object next;
        Object key;
        Iterator<Object> iterator;
        String completionPart = this.calculator.getCompletionPart();
        String corePart = this.calculator.getCorePart();
        int k = corePart.indexOf(91);
        while (k > 0) {
            int k1 = corePart.indexOf(93);
            if (k1 == -1) {
                corePart = corePart.substring(k + 1);
            } else {
                String substring = corePart.substring(0, k + 1);
                corePart = String.valueOf(substring) + corePart.substring(k1);
            }
            k = corePart.indexOf(91);
            if (k != corePart.length() - 1 && corePart.charAt(k + 1) == ']') break;
        }
        Set references = collection.queryElements(corePart, true);
        HashSet searchResults = new HashSet();
        HashMap<String, IReference> dubR = new HashMap<String, IReference>();
        if (!references.isEmpty()) {
            Object next2;
            iterator = references.iterator();
            HashSet fields = new HashSet();
            while (iterator.hasNext()) {
                next2 = iterator.next();
                if (!(next2 instanceof IReference)) continue;
                IReference mnext = (IReference)next2;
                IReference proto = mnext.getPrototype(true);
                if (proto != null) {
                    AbstractCollection protos = new LinkedHashSet<IReference>();
                    while (proto != null && !protos.contains(proto)) {
                        protos.add(proto);
                        proto = proto.getPrototype(false);
                    }
                    protos = new LinkedList(protos);
                    Collections.reverse((List)((Object)protos));
                    Iterator iterator2 = protos.iterator();
                    while (iterator2.hasNext()) {
                        IReference proto1 = (IReference)iterator2.next();
                        fields.addAll(proto1.getChilds(true));
                    }
                }
                fields.addAll(mnext.getChilds(true));
            }
            iterator = fields.iterator();
            while (iterator.hasNext()) {
                next2 = iterator.next();
                if (!(next2 instanceof IReference)) continue;
                IReference name2 = (IReference)next2;
                String refa2 = name2.getName();
                dubR.put(refa2, name2);
            }
        }
        Set resolveGlobals = buildContext.resolveGlobals(String.valueOf(corePart) + '.');
        Iterator it = resolveGlobals.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IReference)) continue;
            IReference r = (IReference)o;
            dubR.put(r.getName(), r);
        }
        this.completeFromMap(position, completionPart, dubR);
        HashMap<Object, IReference> functions = new HashMap<Object, IReference>();
        iterator = dubR.keySet().iterator();
        while (iterator.hasNext()) {
            IReference name3;
            key = iterator.next();
            Object next3 = dubR.get(key);
            if (!(next3 instanceof IReference) || !(name3 = (IReference)next3).isFunctionRef()) continue;
            functions.put(key, name3);
        }
        iterator = functions.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            dubR.remove(key);
        }
        char[][] choices = new char[dubR.size() + searchResults.size()][];
        int ia = 0;
        HashMap<char[], char[][]> parameterNames = new HashMap<char[], char[][]>();
        HashMap<char[], Object> proposalInfo = new HashMap<char[], Object>();
        iterator = dubR.values().iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (!(next instanceof IReference)) continue;
            name = (IReference)next;
            refa = name.getName();
            choices[ia] = refa.toCharArray();
            if (name instanceof UnknownReference) {
                parameterNames.put(choices[ia], ((UnknownReference)name).getParameterNames());
                proposalInfo.put(choices[ia], ((UnknownReference)name).getProposalInfo());
            }
            ++ia;
        }
        iterator = searchResults.iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            String refa3 = (String)next;
            choices[ia++] = refa3.toCharArray();
        }
        this.findElements(completionPart.toCharArray(), choices, true, false, 1, parameterNames, proposalInfo);
        choices = new char[functions.size()][];
        parameterNames = new HashMap();
        proposalInfo = new HashMap();
        ia = 0;
        iterator = functions.values().iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (!(next instanceof IReference)) continue;
            name = (IReference)next;
            refa = name.getName();
            choices[ia] = refa.toCharArray();
            if (name instanceof UnknownReference) {
                parameterNames.put(choices[ia], ((UnknownReference)name).getParameterNames());
                proposalInfo.put(choices[ia], ((UnknownReference)name).getProposalInfo());
            }
            ++ia;
        }
        this.findElements(completionPart.toCharArray(), choices, true, false, 5, parameterNames, proposalInfo);
    }

    private void completeFromMap(int position, String completionPart, HashMap dubR) {
        HashSet<String> rk = new HashSet<String>();
        this.requestor.acceptContext(new CompletionContext());
        this.setSourceRange(position - completionPart.length(), position);
        char[] token = completionPart.toCharArray();
        int length = token.length;
        Iterator<Object> iterator = dubR.values().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof SelfCompletingReference)) continue;
            SelfCompletingReference cm = (SelfCompletingReference)next;
            int knd = cm.getKind();
            char[] name = cm.getName().toCharArray();
            if (length <= name.length && CharOperation.prefixEquals((char[])token, (char[])name, (boolean)false)) {
                CompletionProposal createProposal = this.createProposal(knd, this.actualCompletionPosition);
                createProposal.setName(name);
                createProposal.setCompletion(name);
                createProposal.extraInfo = cm;
                createProposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                this.requestor.accept(createProposal);
            }
            rk.add(((IReference)next).getName());
        }
        iterator = rk.iterator();
        while (iterator.hasNext()) {
            dubR.remove(iterator.next());
        }
    }

    int computeBaseRelevance() {
        return 0;
    }

    private int computeRelevanceForInterestingProposal() {
        return 5;
    }

    protected int computeRelevanceForRestrictions(int accessRuleKind) {
        if (accessRuleKind == 0) {
            return 3;
        }
        return 0;
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List methods, int kind) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                IMethod method = (IMethod)methods.get(i);
                String qname = this.processMethodName(method, tok);
                char[] name = qname.toCharArray();
                if (DLTKCore.DEBUG_COMPLETION) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals((char[])token, (char[])name, (boolean)false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        String[] arguments = null;
                        try {
                            arguments = method.getParameters();
                        }
                        catch (ModelException modelException) {}
                        if (arguments != null && arguments.length > 0) {
                            char[][] args = new char[arguments.length][];
                            int j = 0;
                            while (j < arguments.length) {
                                args[j] = arguments[j].toCharArray();
                                ++j;
                            }
                            proposal.setParameterNames((char[][])args);
                        }
                        if (kind == 5) {
                            StringBuffer sig = new StringBuffer();
                            sig.append(method.getElementName());
                            sig.append('(');
                            if (arguments != null) {
                                int a = 0;
                                while (a < arguments.length) {
                                    sig.append('L');
                                    sig.append("Object");
                                    sig.append(';');
                                    ++a;
                                }
                            }
                            sig.append(')');
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.extraInfo = method;
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void doCompletionOnKeyword(int position, int pos, String startPart) {
        String[] keywords = JavaScriptKeywords.getJavaScriptKeywords();
        char[][] keyWordsArray = new char[keywords.length][];
        int a = 0;
        while (a < keywords.length) {
            keyWordsArray[a] = keywords[a].toCharArray();
            ++a;
        }
        this.findKeywords(startPart.toCharArray(), keyWordsArray, true);
    }

    protected String processFieldName(IField field, String token) {
        return null;
    }
}

