/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceIndexer
extends AbstractIndexer {
    static long maxWorkTime = 0L;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        long started = new Date().getTime();
        SourceIndexerRequestor requestor = this.document.requestor;
        String documentPath = this.document.getPath();
        Path path = new Path(documentPath);
        ISourceElementParser parser = this.document.parser;
        if (!this.document.isExternal()) {
            ISourceModule module;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            IScriptProject scriptProject = DLTKCore.create(project);
            if (requestor == null) {
                requestor = ModelManager.getModelManager().indexManager.getSourceRequestor(scriptProject);
            }
            requestor.setIndexer(this);
            if (parser == null) {
                parser = ModelManager.getModelManager().indexManager.getSourceElementParser(scriptProject);
            }
            parser.setRequestor(requestor);
            String pkgName = "";
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file.exists() && (module = (ISourceModule)DLTKCore.create(file)) != null) {
                IScriptFolder folder = (IScriptFolder)module.getParent();
                pkgName = folder.getElementName();
            }
            requestor.setPackageName(pkgName);
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            parser.parseSourceModule(source, null, name);
        } else {
            if (parser == null || requestor == null) {
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: Add getSourceElementParser here.");
                }
                return;
            }
            parser.setRequestor(requestor);
            requestor.setIndexer(this);
            String ppath = path.toString();
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Correct me please...");
            }
            String pkgName = new Path(ppath.substring(ppath.indexOf("|") + 1)).removeLastSegments(1).toString();
            requestor.setPackageName(pkgName);
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            parser.parseSourceModule(source, null, name);
            long ended = new Date().getTime();
            if (ended - started > maxWorkTime) {
                maxWorkTime = ended - started;
            }
        }
    }
}

