/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Kit;
import com.xored.org.mozilla.javascript.Node;
import com.xored.org.mozilla.javascript.ObjArray;
import com.xored.org.mozilla.javascript.ObjToIntMap;
import com.xored.org.mozilla.javascript.ScriptRuntime;
import java.util.HashMap;

public class ScriptOrFnNode
extends Node {
    private int encodedSourceStart;
    private int encodedSourceEnd;
    private String sourceName;
    private int baseLineno = -1;
    private int endLineno = -1;
    private ObjArray functions;
    private ObjArray regexps;
    private ObjArray itsVariables = new ObjArray();
    private ObjArray variablePositins = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private HashMap itsVariableComment = new HashMap(11);
    private int varStart;
    private Object compilerData;

    public ScriptOrFnNode(int nodeType) {
        super(nodeType);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public final int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public final int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public final void setEncodedSourceBounds(int start, int end) {
        this.encodedSourceStart = start;
        this.encodedSourceEnd = end;
    }

    public Position getPosition(int vIndex) {
        return (Position)this.variablePositins.get(vIndex);
    }

    public final int getBaseLineno() {
        return this.baseLineno;
    }

    public final void setBaseLineno(int lineno) {
        if (lineno < 0 || this.baseLineno >= 0) {
            Kit.codeBug();
        }
        this.baseLineno = lineno;
    }

    public final int getEndLineno() {
        return this.endLineno;
    }

    public final void setEndLineno(int lineno) {
        if (lineno < 0 || this.endLineno >= 0) {
            Kit.codeBug();
        }
        this.endLineno = lineno;
    }

    public final int getFunctionCount() {
        if (this.functions == null) {
            return 0;
        }
        return this.functions.size();
    }

    public final FunctionNode getFunctionNode(int i) {
        return (FunctionNode)this.functions.get(i);
    }

    public final int addFunction(FunctionNode fnNode) {
        if (fnNode == null) {
            Kit.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ObjArray();
        }
        this.functions.add(fnNode);
        return this.functions.size() - 1;
    }

    public final int getRegexpCount() {
        if (this.regexps == null) {
            return 0;
        }
        return this.regexps.size() / 2;
    }

    public final String getRegexpString(int index) {
        return (String)this.regexps.get(index * 2);
    }

    public final String getRegexpFlags(int index) {
        return (String)this.regexps.get(index * 2 + 1);
    }

    public final int addRegexp(String string, String flags) {
        if (string == null) {
            Kit.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ObjArray();
        }
        this.regexps.add(string);
        this.regexps.add(flags);
        return this.regexps.size() / 2 - 1;
    }

    public final boolean hasParamOrVar(String name) {
        return this.itsVariableNames.has(name);
    }

    public final int getParamOrVarIndex(String name) {
        return this.itsVariableNames.get(name, -1);
    }

    public final String getParamOrVarName(int index) {
        return (String)this.itsVariables.get(index);
    }

    public final int getParamCount() {
        return this.varStart;
    }

    public final int getParamAndVarCount() {
        return this.itsVariables.size();
    }

    public final String[] getParamAndVarNames() {
        int N = this.itsVariables.size();
        if (N == 0) {
            return ScriptRuntime.emptyStrings;
        }
        Object[] array = new String[N];
        this.itsVariables.toArray(array);
        return array;
    }

    public final String getParamComments(String name) {
        return (String)this.itsVariableComment.get(name);
    }

    public final void addParam(String name) {
        if (this.varStart != this.itsVariables.size()) {
            Kit.codeBug();
        }
        int index = this.varStart++;
        this.itsVariables.add(name);
        this.variablePositins.add(new Position(0, 0));
        this.itsVariableNames.put(name, index);
    }

    public final void addVar(String name, int nameStart, int nameEnd, String comment) {
        int vIndex = this.itsVariableNames.get(name, -1);
        if (vIndex != -1) {
            return;
        }
        int index = this.itsVariables.size();
        this.variablePositins.add(new Position(nameStart, nameEnd));
        this.itsVariables.add(name);
        this.itsVariableNames.put(name, index);
        this.itsVariableComment.put(name, comment);
    }

    public final void removeParamOrVar(String name) {
        int i = this.itsVariableNames.get(name, -1);
        if (i != -1) {
            this.itsVariables.remove(i);
            this.itsVariableNames.remove(name);
            this.itsVariableComment.remove(name);
            ObjToIntMap.Iterator iter = this.itsVariableNames.newIterator();
            iter.start();
            while (!iter.done()) {
                int v = iter.getValue();
                if (v > i) {
                    iter.setValue(v - 1);
                }
                iter.next();
            }
        }
    }

    public final Object getCompilerData() {
        return this.compilerData;
    }

    public final void setCompilerData(Object data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerData != null) {
            throw new IllegalStateException();
        }
        this.compilerData = data;
    }

    public static class Position {
        public int start;
        public int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

