/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ruby.typeinference.IArgumentsContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.IInstanceContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class MethodContext
implements IContext,
IArgumentsContext,
IInstanceContext,
ISourceModuleContext {
    private final ISourceModule sourceModule;
    private final ModuleDeclaration rootNode;
    private final String[] argNames;
    private final IEvaluatedType[] argTypes;
    private IEvaluatedType instanceType;

    public MethodContext(IContext parent, ISourceModule sourceModule, ModuleDeclaration rootNode, String[] argNames, IEvaluatedType[] argTypes) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
        this.argNames = argNames;
        this.argTypes = argTypes;
        if (parent instanceof IInstanceContext) {
            this.instanceType = ((IInstanceContext)parent).getInstanceType();
        }
    }

    public IEvaluatedType getArgumentType(String name) {
        int i = 0;
        while (i < this.argNames.length) {
            String argName = this.argNames[i];
            if (name.equals(argName)) {
                if (i < this.argTypes.length) {
                    return this.argTypes[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public IEvaluatedType getInstanceType() {
        return this.instanceType;
    }

    public ModuleDeclaration getRootNode() {
        return this.rootNode;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public String getLangNature() {
        IDLTKLanguageToolkit languageToolkit;
        if (this.sourceModule != null && (languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.sourceModule)) != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }
}

