/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.tests.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.tests.launching.IFileVisitor;
import org.eclipse.dltk.core.tests.launching.PathFilesContainer;
import org.eclipse.dltk.core.tests.launching.ScriptLaunchingTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.tcl.internal.debug.TclDebugPlugin;
import org.eclipse.dltk.tcl.launching.TclLaunchConfigurationDelegate;

public class TclLaunchingTests
extends ScriptLaunchingTests {
    private static final String DBGP_TCLDEBUG = "/home/dltk/apps/tcl_debug/dbgp_tcldebug";
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    public TclLaunchingTests(String name) {
        super("org.eclipse.dltk.tcl.core.tests", name);
    }

    public TclLaunchingTests(String testProjectName, String name) {
        super(testProjectName, name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.core.tests.launching.TclLaunchingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    protected String getProjectName() {
        return "launching";
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected String getDebugModelId() {
        return "org.eclipse.dltk.debug.tclModel";
    }

    protected ILaunchConfiguration createLaunchConfiguration(String arguments) {
        return this.createTestLaunchConfiguration(this.getNatureId(), this.getProjectName(), "src/test.tcl", arguments);
    }

    protected void startLaunch(ILaunch launch, final IInterpreterInstall install) throws CoreException {
        TclLaunchConfigurationDelegate delegate = new TclLaunchConfigurationDelegate(){

            public IInterpreterInstall getInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
                return install;
            }
        };
        delegate.launch(launch.getLaunchConfiguration(), launch.getLaunchMode(), launch, null);
    }

    public void testDebugTclsh() throws Exception {
        this.initializeActiveStateDebugEngine();
        ScriptLaunchingTests.DebugEventStats stats = super.internalTestDebug("tclsh");
        int suspendCount = stats.getSuspendCount();
        TclLaunchingTests.assertEquals((int)2, (int)suspendCount);
        TclLaunchingTests.assertEquals((int)3, (int)stats.getResumeCount());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        TclLaunchingTests.assertEquals((int)3, (int)stats.getBeforeResumeCount());
        TclLaunchingTests.assertEquals((int)2, (int)stats.getBeforeSuspendCount());
    }

    public void testDebugWish() throws Exception {
        this.initializeActiveStateDebugEngine();
        ScriptLaunchingTests.DebugEventStats stats = super.internalTestDebug("wish");
        int suspendCount = stats.getSuspendCount();
        TclLaunchingTests.assertEquals((int)2, (int)suspendCount);
        TclLaunchingTests.assertEquals((int)3, (int)stats.getResumeCount());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        TclLaunchingTests.assertEquals((int)3, (int)stats.getBeforeResumeCount());
        TclLaunchingTests.assertEquals((int)2, (int)stats.getBeforeSuspendCount());
    }

    public void testDebugExpect() throws Exception {
        this.initializeActiveStateDebugEngine();
        ScriptLaunchingTests.DebugEventStats stats = super.internalTestDebug("expect");
        int suspendCount = stats.getSuspendCount();
        TclLaunchingTests.assertEquals((int)2, (int)suspendCount);
        TclLaunchingTests.assertEquals((int)3, (int)stats.getResumeCount());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        TclLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        TclLaunchingTests.assertEquals((int)3, (int)stats.getBeforeResumeCount());
        TclLaunchingTests.assertEquals((int)2, (int)stats.getBeforeSuspendCount());
    }

    private void initializeActiveStateDebugEngine() {
        if (this.initialized) {
            return;
        }
        TclDebugPlugin.getDefault().getPluginPreferences().setValue("debugging_engine_id", "org.eclipse.dltk.tcl.activestatedebugger");
        TclActiveStateDebuggerPlugin plugin = TclActiveStateDebuggerPlugin.getDefault();
        String path = DBGP_TCLDEBUG;
        File file = new File(path);
        boolean inDefault = true;
        if (!file.exists()) {
            PathFilesContainer container = new PathFilesContainer(EnvironmentManager.getLocalEnvironment());
            Searcher searcher = new Searcher();
            container.accept((IFileVisitor)searcher);
            path = searcher.getPath();
            inDefault = false;
        }
        if (!inDefault && path == null) {
            TclLaunchingTests.assertNotNull((String)"Couldn't find ActiveState debugger", (Object)path);
        }
        HashMap<IEnvironment, String> map = new HashMap<IEnvironment, String>();
        map.put(LocalEnvironment.getInstance(), path);
        String keyValue = EnvironmentPathUtils.encodePaths(map);
        plugin.getPluginPreferences().setValue("debugging_engine_path", keyValue);
        this.initialized = true;
    }

    protected IInterpreterInstall[] getPredefinedInterpreterInstalls() {
        IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes((String)"org.eclipse.dltk.tcl.core.nature");
        int id = 0;
        ArrayList installs = new ArrayList();
        int i = 0;
        while (i < installTypes.length) {
            String installId = String.valueOf(this.getNatureId()) + "_";
            this.createAddInstall(installs, "/usr/bin/tclsh", String.valueOf(installId) + Integer.toString(++id), installTypes[i]);
            this.createAddInstall(installs, "/usr/bin/expect", String.valueOf(installId) + Integer.toString(++id), installTypes[i]);
            this.createAddInstall(installs, "/usr/bin/wish", String.valueOf(installId) + Integer.toString(++id), installTypes[i]);
            ++i;
        }
        if (installs.size() > 0) {
            return installs.toArray(new IInterpreterInstall[installs.size()]);
        }
        return this.searchInstalls("org.eclipse.dltk.tcl.core.nature");
    }

    protected boolean hasPredefinedInterpreters() {
        return true;
    }

    public void testTclsh() throws Exception {
        String NAME = "tclsh";
        this.internalTestRequiredInterpreterAvailable(NAME);
        this.internalTestRun(NAME);
    }

    public void testWish() throws Exception {
        String NAME = "wish";
        this.internalTestRequiredInterpreterAvailable(NAME);
        this.internalTestRun(NAME);
    }

    public void testExpect() throws Exception {
        String NAME = "expect";
        this.internalTestRequiredInterpreterAvailable(NAME);
        this.internalTestRun(NAME, 1);
    }

    protected void configureEnvironment(Map env) {
    }

    class Searcher
    implements IFileVisitor {
        private String debuggingEnginePath = null;

        Searcher() {
        }

        public boolean visit(IFileHandle file) {
            if (file.isFile() && file.getName().startsWith("dbgp_tcldebug")) {
                this.debuggingEnginePath = file.toOSString();
            }
            return file.isDirectory() && this.debuggingEnginePath == null;
        }

        public String getPath() {
            return this.debuggingEnginePath;
        }
    }
}

