/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.tests.model;

import java.util.Arrays;
import junit.framework.Test;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.AbstractModelCompletionTests;
import org.eclipse.dltk.core.tests.model.CompletionTestsRequestor;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class CompletionTests
extends AbstractModelCompletionTests {
    private static final int RELEVANCE = 18;
    static /* synthetic */ Class class$0;

    public CompletionTests(String name) {
        super("org.eclipse.dltk.tcl.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        this.PROJECT = this.setUpScriptProject("Completion");
        super.setUpSuite();
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.core.tests.model.CompletionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    private String makeResult(String[] elements, String[] completions, int[] relevance) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append("element:" + elements[i] + "    completion:" + completions[i] + "    relevance:" + relevance[i]);
            if (i != elements.length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String makeResult(String[] elements) {
        String[] completions = new String[elements.length];
        int[] relevance = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            completions[i] = elements[i];
            relevance[i] = 18;
            ++i;
        }
        return this.makeResult(elements, completions, relevance);
    }

    private String makeResult(String[] elements, int[] relevance) {
        String[] completions = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            completions[i] = elements[i];
            ++i;
        }
        return this.makeResult(elements, completions, relevance);
    }

    private static int newLineAfter(String str, String marker) {
        int location = str.indexOf(marker);
        CompletionTests.assertTrue((location >= 0 ? 1 : 0) != 0);
        location += marker.length();
        while (location < str.length() && str.charAt(location) != '\r' && str.charAt(location) != '\n') {
            ++location;
        }
        if (location < str.length() && str.charAt(location) == '\r') {
            ++location;
        }
        if (location < str.length() && str.charAt(location) == '\n') {
            ++location;
        }
        return location;
    }

    public void testCompletion001() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "CompletionKeywordNamespace1.tcl");
        String str = cu.getSource();
        String completeBehind = "nam";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"namespace", "namespace children", "namespace code", "namespace current", "namespace delete", "namespace eval", "namespace export", "namespace forget", "namespace import", "namespace inscope", "namespace parent", "namespace qualifiers", "namespace tail", "namespace which"}), (String)requestor.getResults());
    }

    public void testCompletion002() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "CompletionKeywordNamespace1.tcl");
        String str = cu.getSource();
        String completeBehind = "pa";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"package", "package provide", "package require", "part"}), (String)requestor.getResults());
    }

    public void testCompletion003() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "Completion002.tcl");
        String str = cu.getSource();
        int cursorLocation = CompletionTests.newLineAfter(str, "#2") + 10;
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"::a::c::fac()"}, new String[]{"::a::c::fac"}, new int[]{18}), (String)requestor.getResults());
    }

    public void testCompletion004() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "Completion002.tcl");
        String str = cu.getSource();
        int cursorLocation = CompletionTests.newLineAfter(str, "#1") + 9;
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"::a::c::fac()", "::a::c::fbac()", "::a::c::feac()"}, new String[]{"::a::c::fac", "::a::c::fbac", "::a::c::feac"}, new int[]{18, 18, 18}), (String)requestor.getResults());
    }

    public void testCompletion005() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "Completion002.tcl");
        String str = cu.getSource();
        int cursorLocation = CompletionTests.newLineAfter(str, "#3") + 6;
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String[] result1 = new String[]{"::a::f::faf", "::a::f::q::faf_q", "::a::f::q::fafq", "::a::f::q::t::fafqt", "::a::fa"};
        String[] result2 = new String[result1.length];
        int i = 0;
        while (i < result1.length) {
            result2[i] = result1[i];
            int n = i++;
            result1[n] = String.valueOf(result1[n]) + "()";
        }
        int[] relevance = new int[result1.length];
        Arrays.fill(relevance, 18);
        CompletionTests.assertEquals((String)this.makeResult(result1, result2, relevance), (String)requestor.getResults());
    }

    public void testCompletion006() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "Completion002.tcl");
        String str = cu.getSource();
        int cursorLocation = CompletionTests.newLineAfter(str, "#4") + 7;
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"::b::fb()"}, new String[]{"::b::fb"}, new int[]{22}), (String)requestor.getResults());
    }

    public void testCompletion007() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "completion003.tcl");
        String str = cu.getSource();
        String s = "puts $";
        int cursorLocation = str.indexOf(s) + s.length();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"$::x", "$x"}, new int[]{18, 18}), (String)requestor.getResults());
    }

    public void testCompletion008() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("Completion", "src", "completion004.tcl");
        String str = cu.getSource();
        int cursorLocation = CompletionTests.newLineAfter(str, "puts \"");
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        CompletionTests.assertEquals((String)this.makeResult(new String[]{"$::x", "$x"}, new int[]{18, 18}), (String)requestor.getResults());
    }
}

