/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.tests.model;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchConstants;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.tests.model.AbstractDLTKSearchTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class SearchTests
extends AbstractDLTKSearchTests
implements IDLTKSearchConstants {
    private static final String TCLSEARCH = "PROJ_TCLSearch";
    private static final String TCLSEARCH2 = "PROJ_TCLSearch2";
    static /* synthetic */ Class class$0;

    public SearchTests(String name) {
        super("org.eclipse.dltk.tcl.core.tests", name);
    }

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.core.tests.model.SearchTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.up();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(TCLSEARCH);
        this.deleteProject(TCLSEARCH2);
        super.tearDownSuite();
    }

    private void up() throws Exception {
        if (this.SCRIPT_PROJECT == null) {
            this.SCRIPT_PROJECT = this.setUpScriptProjectTo(TCLSEARCH, "TCLSearch");
            this.setUpScriptProjectTo(TCLSEARCH2, "TCLSearch2");
        }
    }

    public void testNamespaceDeclaration01() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p/X.tcl").getType("X");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p/X.tcl p/X", this.resultCollector);
    }

    public void testNamespaceDeclaration02() throws Exception {
        this.up();
        IScriptFolder pkg = this.getScriptFolder(TCLSEARCH, "src", (IPath)new Path("p1"));
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)pkg);
        this.search("Y", 0, 0, scope);
        this.assertSearchResults("src/p1/test.tcl p1/Y", this.resultCollector);
    }

    public void testNamespaceDeclaration03() throws Exception {
        this.up();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getScriptProject(TCLSEARCH));
        this.search("*", 0, 0, scope);
        this.assertSearchResults("src/X.tcl X\nsrc/p/X.tcl p/X\nsrc/p1/test.tcl p1/Y\nsrc/p2/X.tcl p2/X\nsrc/p2/X.tcl p2/Y\nsrc/p3/X.tcl p3/X\nsrc/p3/X.tcl p3/X$T1\nsrc/p3/X.tcl p3/X$T1$T1\nsrc/p3/X.tcl p3/Y\nsrc/p3/X.tcl p3/Y$T2\nsrc/p3/X.tcl p3/Y$T2$T3\nsrc/p3/X.tcl p3/Y$T2$T3$T4\nsrc/p3/X.tcl p3/Z\nsrc/p3/X.tcl p3/Z$T2\nsrc/p3/X.tcl p3/Z$T2$T3\nsrc/p3/X.tcl p3/Z$T2$T3$T4\nsrc/p4/t.tcl p4/alfa\nsrc/q5/AQ.tcl q5/I\nsrc/q5/AQ.tcl q5/I2", this.resultCollector);
    }

    public void testNamespaceDeclaration05() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p3/X.tcl").getType("Z").getType("T2");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p3/X.tcl p3/Z$T2", this.resultCollector);
    }

    public void testNamespaceDeclaration06() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p3/X.tcl").getType("Z").getType("T2").getType("T3");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p3/X.tcl p3/Z$T2$T3", this.resultCollector);
    }

    public void testNamespaceDeclaration07() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p3/X.tcl").getType("Z").getType("T2").getType("T3").getType("T4");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p3/X.tcl p3/Z$T2$T3$T4", this.resultCollector);
    }

    public void testNamespaceDeclaration08() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p3/X.tcl").getType("Z");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p3/X.tcl p3/Z", this.resultCollector);
    }

    public void testNamespaceDeclaration09() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", "p4/t.tcl").getType("alfa");
        this.search((IModelElement)type, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p4/t.tcl p4/alfa", this.resultCollector);
    }

    public void testMethodDeclaration00() throws Exception {
        this.up();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getScriptProject(TCLSEARCH));
        this.search("*", 1, 0, scope);
        this.assertSearchResults("src/X.tcl  X$a()\nsrc/p/X.tcl  p/X$foo()\nsrc/p1/test.tcl  p1/Y$foo()\nsrc/p2/X.tcl  p2/X$foo()\nsrc/p2/X.tcl  p2/Y$foo()\nsrc/p3/X.tcl  p3/X$src_p3_X_X_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/X$foo()\nsrc/p3/X.tcl  p3/X$T1$src_p3_X_X_T1_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/X$T1$T1$src_p3_X_X_T1_T1_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/Y$src_p3_X_Y_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/Y$foo()\nsrc/p3/X.tcl  p3/Y$T2$T3$T4$src_p3_X_Y_T2_T3_T4_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/Z$foo()\nsrc/p3/X.tcl  $src_p3_X_function(arg1, arg2, arg3)\nsrc/p3/X.tcl  p3/global2$namespace2$function(arg1, arg2, arg3)\nsrc/q5/AQ.tcl  q5/I$k(arg)\nsrc/q5/AQ.tcl  q5/I2$k(arg)\nsrc/q5/AQ.tcl  $m()", this.resultCollector);
    }

    public void testMethodDeclaration01() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("p/X.tcl")).getType("X");
        IMethod method = type.getMethod("foo");
        this.search((IModelElement)method, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p/X.tcl  p/X$foo()\nsrc/p2/X.tcl  p2/X$foo()\nsrc/p3/X.tcl  p3/X$foo()", this.resultCollector);
    }

    public void testMethodDeclaration02() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("p3/X.tcl")).getType("Y").getType("T2").getType("T3").getType("T4");
        IMethod method = type.getMethod("src_p3_X_Y_T2_T3_T4_function");
        this.search((IModelElement)method, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p3/X.tcl  p3/Y$T2$T3$T4$src_p3_X_Y_T2_T3_T4_function(arg1, arg2, arg3)", this.resultCollector);
    }

    public void testMethodReference01() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("q5/AQ.tcl")).getType("I");
        IMethod method = type.getMethod("k");
        this.search((IModelElement)method, 1, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/q5/AQ.tcl q5/I\nsrc/q5/AQ.tcl  $m()\nsrc/q5/AQ.tcl\nsrc/q5/AQ.tcl", this.resultCollector);
    }

    public void testMethodReference02() throws Exception {
        this.up();
        IMethod method = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("q5/AQ.tcl")).getMethod("m");
        this.search((IModelElement)method, 1, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/q5/AQ.tcl q5/I\nsrc/q5/AQ.tcl q5/I2\nsrc/q5/AQ.tcl", this.resultCollector);
    }

    public void testTypeReference01() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("X.tcl")).getType("X");
        this.search((IModelElement)type, 1, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/X.tcl", this.resultCollector);
    }

    public void testTypeReference02() throws Exception {
        this.up();
        IType type = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("q5/AQ.tcl")).getType("I");
        this.search((IModelElement)type, 1, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/q5/AQ.tcl q5/I\nsrc/q5/AQ.tcl q5/I2\nsrc/q5/AQ.tcl  $m()\nsrc/q5/AQ.tcl\nsrc/q5/AQ.tcl", this.resultCollector);
    }

    public void testVariableDeclaration01() throws Exception {
        this.up();
        IField field = this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("p/X.tcl")).getField("globalX");
        this.search((IModelElement)field, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p/X.tcl globalX", this.resultCollector);
    }

    public void testVariableDeclaration02() throws Exception {
        this.up();
        this.getSourceModule(TCLSEARCH, "src", (IPath)new Path("p3/X.tcl"));
        this.search("*", 2, 0, this.getSearchScope(TCLSEARCH));
        this.assertSearchResults("src/p/X.tcl globalX\nsrc/p3/X.tcl p3/X$T1$T1$v6\nsrc/p3/X.tcl p3/X$T1$v5\nsrc/p3/X.tcl p3/X$v1\nsrc/p3/X.tcl p3/X$v2\nsrc/p3/X.tcl p3/X$v3\nsrc/p3/X.tcl p3/X$v4\nsrc/p3/X.tcl v8\nsrc/p3/X.tcl p3/Y$T2$T3$v10\nsrc/p3/X.tcl p3/Y$T2$v9\nsrc/p3/X.tcl p3/Y$v7\nsrc/p3/X.tcl p3/Z$T2$T3$T4$v11\nsrc/p4/t.tcl p4/alfa$superFU\nsrc/p4/t.tcl p4/alfa$superFU\nsrc/p4/t.tcl p4/alfa$superFU", this.resultCollector);
    }

    public void testVariableDeclaration03() throws Exception {
        this.up();
        this.getScriptProject(TCLSEARCH);
        List sources = this.searchSourceOnly("*", 2, 0, this.getSearchScope(TCLSEARCH));
        SearchTests.assertNotNull((Object)sources);
        int i = 0;
        while (i < sources.size()) {
            ISourceModule element = (ISourceModule)sources.get(i);
            SearchTests.assertNotNull((Object)element);
            System.out.println(element.getElementName());
            ++i;
        }
    }

    public void testMethod001() throws Exception {
        this.up();
        this.search("a::*", 1, 0, this.getSearchScope(TCLSEARCH2));
        this.assertSearchResults("src/X.tcl  a$alfa()\nsrc/X.tcl  a$beta()", this.resultCollector);
    }

    public void testMethod002() throws Exception {
        this.up();
        this.search("a*::alfa", 1, 0, this.getSearchScope(TCLSEARCH2));
        this.assertSearchResults("src/X.tcl  a$b$alfa()\nsrc/X.tcl  a$d$alfa()\nsrc/X.tcl  a$alfa()", this.resultCollector);
    }
}

