/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.tests.model;

import junit.framework.Test;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.AbstractModelCompletionTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class TclSelectionTests
extends AbstractModelCompletionTests {
    private static final String SELECTION_PROJECT = "TCL_Selection";
    static /* synthetic */ Class class$0;

    public TclSelectionTests(String name) {
        super("org.eclipse.dltk.tcl.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        this.PROJECT = this.setUpScriptProjectTo(SELECTION_PROJECT, "Selection");
        super.setUpSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.tcl.core.tests.model.TclSelectionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void testselection001() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        int start = source.indexOf("proc fa") + 5;
        String sub = source.substring(start, start + 2);
        TclSelectionTests.assertEquals((String)"fa", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 2);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getMethod("fa");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection002() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        int start = source.indexOf("proc fac") + 5;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"fac", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("c").getMethod("fac");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection003() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        int start = source.indexOf("proc fbac") + 5;
        String sub = source.substring(start, start + 4);
        TclSelectionTests.assertEquals((String)"fbac", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 4);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((String)"Failed to select fbac method from namespace ::a::c declared from ::b", (int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("c").getMethod("fbac");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection004() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        int start = source.indexOf("proc fb") + 5;
        String sub = source.substring(start, start + 2);
        TclSelectionTests.assertEquals((String)"fb", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 2);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("b").getMethod("fb");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection005() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::c::fac";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("c").getMethod("fac");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection006() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::fa";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getMethod("fa");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection007() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::c::fbac";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("c").getMethod("fbac");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection008() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::c::feac";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("c").getMethod("feac");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testselection009() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::f::q::faf_q";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("f").getType("q").getMethod("faf_q");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelection010() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::f::q::fafq";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("f").getType("q").getMethod("fafq");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelection011() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection001.tcl");
        String source = cu.getSource();
        String s = "::a::f::q::t::fafqt";
        int start = source.indexOf(s);
        String sub = source.substring(start, start + s.length());
        TclSelectionTests.assertEquals((String)s, (String)sub);
        IModelElement[] elements = cu.codeSelect(start, s.length());
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("a").getType("f").getType("q").getType("t").getMethod("fafqt");
        TclSelectionTests.assertNotNull((Object)method);
        TclSelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelection012() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts $x1";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"$x1", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection013() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"a $x1";
        int start = source.indexOf(s) + 8;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"$x1", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection014() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"a$x1";
        int start = source.indexOf(s) + 7;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"$x1", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection015() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"$x1\"";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"$x1", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection016() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts ${x1}";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 5);
        TclSelectionTests.assertEquals((String)"${x1}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 5);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection017() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts ${x1}";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 5);
        TclSelectionTests.assertEquals((String)"${x1}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 5);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void process018(int add, int size) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts ${x1 2}";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 7);
        TclSelectionTests.assertEquals((String)"${x1 2}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1 2");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void process023(int add, int size) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"${x1 2}\"";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 7);
        TclSelectionTests.assertEquals((String)"${x1 2}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x1 2");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection018() throws ModelException {
        this.process018(0, 7);
    }

    public void testSelection019() throws ModelException {
        this.process018(2, 1);
    }

    public void testSelection019a() throws ModelException {
        this.process018(2, 0);
    }

    public void testSelection020() throws ModelException {
        this.process018(3, 1);
    }

    public void testSelection020a() throws ModelException {
        this.process018(3, 0);
    }

    public void REM_testSelection021() throws ModelException {
        this.process018(4, 1);
    }

    public void testSelection021a() throws ModelException {
        this.process018(4, 0);
    }

    public void testSelection022() throws ModelException {
        this.process018(5, 1);
    }

    public void testSelection022a() throws ModelException {
        this.process018(5, 0);
    }

    public void REM_testSelection023() throws ModelException {
        this.process023(5, 0);
    }

    public void testSelection023a() throws ModelException {
        this.process023(0, 7);
    }

    public void testSelection023b() throws ModelException {
        this.process023(2, 1);
    }

    public void testSelection023c() throws ModelException {
        this.process023(2, 0);
    }

    public void testSelection023d() throws ModelException {
        this.process023(3, 1);
    }

    public void testSelection023e() throws ModelException {
        this.process023(3, 0);
    }

    public void REM_testSelection023f() throws ModelException {
        this.process023(4, 1);
    }

    public void testSelection023g() throws ModelException {
        this.process023(4, 0);
    }

    public void REM_testSelection023h() throws ModelException {
        this.process023(5, 1);
    }

    public void REM_testSelection023i() throws ModelException {
        this.process023(5, 0);
    }

    public void process024(int add, int size) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts $x2(0)";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 6);
        TclSelectionTests.assertEquals((String)"$x2(0)", (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field1 = cu.getField("x2");
        TclSelectionTests.assertNotNull((Object)field1);
        TclSelectionTests.assertEquals((Object)field1, (Object)elements[0]);
    }

    public void testSelection024a() throws ModelException {
        this.process024(0, 6);
    }

    public void testSelection024b() throws ModelException {
        this.process024(3, 0);
    }

    public void process025(int add, int size) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"$x2(0)";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 6);
        TclSelectionTests.assertEquals((String)"$x2(0)", (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x2(0)");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection025a() throws ModelException {
        this.process024(0, 6);
    }

    public void testSelection025b() throws ModelException {
        this.process024(3, 0);
    }

    public void process026(int add, int size) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts \"${x2(0)}";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 6);
        TclSelectionTests.assertEquals((String)"${x2(0)}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x2(0)");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection026a() throws ModelException {
        this.process024(0, 6);
    }

    public void testSelection026b() throws ModelException {
        this.process024(3, 0);
    }

    public void testSelection27a() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts $x3";
        int start = source.indexOf(s) + 5;
        String sub = source.substring(start, start + 3);
        TclSelectionTests.assertEquals((String)"$x3", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 3);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x3");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void testSelection27b() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = cu.getSource();
        String s = "puts ${x3}";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 4);
        TclSelectionTests.assertEquals((String)"{x3}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, 4);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x3");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public void REM_testSelection27c() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String source = "set x3 42\nputs ${x3}";
        String s = "puts ${x3}";
        int start = source.indexOf(s) + 6;
        String sub = source.substring(start, start + 4);
        TclSelectionTests.assertEquals((String)"{x3}", (String)sub);
        IModelElement[] elements = cu.codeSelect(start, source.length() - 1);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        IField field = cu.getField("x3");
        TclSelectionTests.assertNotNull((Object)field);
        TclSelectionTests.assertEquals((Object)field, (Object)elements[0]);
    }

    public IModelElement process028(ISourceModule cu, String pattern, int sadd, int add, int size) throws ModelException {
        String source = cu.getSource();
        int start = source.indexOf(pattern) + sadd;
        String sub = source.substring(start, start + pattern.length() - sadd);
        TclSelectionTests.assertEquals((String)pattern.substring(sadd), (String)sub);
        IModelElement[] elements = cu.codeSelect(start + add, size);
        TclSelectionTests.assertNotNull((Object)elements);
        TclSelectionTests.assertEquals((int)1, (int)elements.length);
        return elements[0];
    }

    public void testSelection028() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::c::vac";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("c").getField("vac");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection029() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::c::vac2";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("c").getField("vac2");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection030() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::c::vac4";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("c").getField("vac4");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection031() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::f::q::t::vafqt0";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("f").getType("q").getType("t").getField("vafqt0");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection032() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::f::q::vafq";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("f").getType("q").getField("vafq");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection033() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::f::q::vafq2";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("f").getType("q").getField("vafq2");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection034() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::f::vaf";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getType("f").getField("vaf");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection035() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::a::va";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("a").getField("va");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void REM_testSelection036() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::b::a::c::vca3";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("b").getType("a").getType("c").getField("vca3");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection037() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection003.tcl");
        String s = "puts $::b::vb";
        int i = 5;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getType("b").getField("vb");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection038() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String s = "puts [$x6]";
        int i = 7;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getField("x6");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection039() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String s = "puts \"[$x6]\"";
        int i = 8;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getField("x6");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }

    public void testSelection040() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection002.tcl");
        String s = "puts $x7";
        int i = 6;
        IModelElement element = this.process028(cu, s, i, 0, s.length() - i);
        IField field = cu.getField("x7");
        TclSelectionTests.assertEquals((Object)field, (Object)element);
    }
}

