/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.tcl.core.tests.model.Activator;
import org.eclipse.dltk.tcl.internal.parsers.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.MagicBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.NormalBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclWord;
import org.eclipse.dltk.tcl.internal.parsers.raw.VariableSubstitution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleParserTests
extends TestCase {
    /*
     * Exception decompiling
     */
    private String getContents(URL url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void print(TclWord s) {
        System.out.println(" - - word from " + s.getStart() + " to " + s.getEnd());
        List cmd = s.getContents();
        Iterator iter = cmd.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            System.out.println(" - - - " + o.toString());
            if (!(o instanceof CommandSubstitution)) continue;
            System.out.println("# internal script #");
            this.print(((CommandSubstitution)o).getScript());
            System.out.println("# end of internal script #");
        }
    }

    private void print(TclCommand s) {
        System.out.println(" - command from " + s.getStart() + " to " + s.getEnd());
        List cmd = s.getWords();
        Iterator iter = cmd.iterator();
        while (iter.hasNext()) {
            TclWord word = (TclWord)iter.next();
            this.print(word);
        }
    }

    private void print(TclScript s) {
        System.out.println("script from " + s.getStart() + " to " + s.getEnd());
        List cmd = s.getCommands();
        Iterator iter = cmd.iterator();
        while (iter.hasNext()) {
            TclCommand c = (TclCommand)iter.next();
            if (c == null) {
                System.out.println("comment(AND ERROR TOO, no null ptr should be in result) here!");
                continue;
            }
            this.print(c);
        }
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    private String getCodeRange(String code, int start, int end) {
        return code.substring(start, end + 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parseXML(String source) {
        Document doc = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(source.getBytes());
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    doc = parser.parse(new InputSource(stream));
                }
                catch (SAXException sAXException) {
                    throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    ((InputStream)stream).close();
                    throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ((InputStream)stream).close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                ((InputStream)stream).close();
                return doc;
            }
        }
        catch (IOException iOException) {}
        return doc;
    }

    private Document createXMLFromSource(String source, TclScript s) {
        try {
            Document doc = SimpleParserTests.getDocument();
            this.getXML(source, s, doc);
            return doc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Node getWordAsNode(String source, TclWord word, Document doc) {
        Element w = doc.createElement("word");
        w.setAttribute("start", Integer.toString(word.getStart()));
        w.setAttribute("end", Integer.toString(word.getEnd()));
        String wordRawText = this.getCodeRange(source, word.getStart(), word.getEnd());
        w.setAttribute("text", wordRawText);
        List parts = word.getContents();
        Iterator wordIter = parts.iterator();
        while (wordIter.hasNext()) {
            String rawText;
            Object o = wordIter.next();
            Element p = null;
            if (o instanceof String) {
                p = doc.createElement("string");
                p.setAttribute("text", o.toString());
            } else if (o instanceof CommandSubstitution) {
                CommandSubstitution cs = (CommandSubstitution)o;
                p = doc.createElement("command");
                String code = this.getCodeRange(source, cs.getStart(), cs.getEnd());
                if (code == null) {
                    throw new NullPointerException("failed to get source from " + cs.getStart() + " to " + cs.getEnd());
                }
                p.setAttribute("text", code);
            } else if (o instanceof QuotesSubstitution) {
                p = doc.createElement("quotes");
                rawText = this.getCodeRange(source, ((QuotesSubstitution)o).getStart(), ((QuotesSubstitution)o).getEnd());
                if (rawText == null) {
                    throw new NullPointerException(String.valueOf(o.toString()) + " has null raw text");
                }
                p.setAttribute("text", rawText);
            } else if (o instanceof BracesSubstitution) {
                p = doc.createElement("braces");
                rawText = this.getCodeRange(source, ((BracesSubstitution)o).getStart(), ((BracesSubstitution)o).getEnd());
                if (rawText == null) {
                    throw new NullPointerException(String.valueOf(o.toString()) + " has null raw text");
                }
                p.setAttribute("text", rawText);
            } else if (o instanceof VariableSubstitution) {
                p = doc.createElement("variable");
                VariableSubstitution vs = (VariableSubstitution)o;
                p.setAttribute("start", Integer.toString(vs.getStart()));
                p.setAttribute("end", Integer.toString(vs.getEnd()));
                p.setAttribute("kind", Integer.toString(vs.getKind()));
                if (vs.getName() == null) {
                    throw new NullPointerException(String.valueOf(o.toString()) + " has null name");
                }
                p.setAttribute("name", vs.getName());
                if (vs.getIndex() != null) {
                    p.appendChild(this.getWordAsNode(source, vs.getIndex(), doc));
                }
            } else if (o instanceof NormalBackslashSubstitution) {
                p = doc.createElement("normalbs");
                rawText = this.getCodeRange(source, ((NormalBackslashSubstitution)o).getStart(), ((NormalBackslashSubstitution)o).getEnd());
                if (rawText == null) {
                    throw new NullPointerException(String.valueOf(o.toString()) + " has null raw text");
                }
                p.setAttribute("text", rawText);
            } else if (o instanceof MagicBackslashSubstitution) {
                p = doc.createElement("newlinebs");
            }
            w.appendChild(p);
        }
        return w;
    }

    private Node getXML(String source, TclScript s, Document doc) {
        Element script = doc.createElement("script");
        doc.appendChild(script);
        List cmd = s.getCommands();
        Iterator iter = cmd.iterator();
        while (iter.hasNext()) {
            TclCommand c = (TclCommand)iter.next();
            Element command = doc.createElement("command");
            command.setAttribute("start", Integer.toString(c.getStart()));
            command.setAttribute("end", Integer.toString(c.getEnd()));
            script.appendChild(command);
            List words = c.getWords();
            Iterator cmdIter = words.iterator();
            while (cmdIter.hasNext()) {
                TclWord word = (TclWord)cmdIter.next();
                Node w = this.getWordAsNode(source, word, doc);
                command.appendChild(w);
            }
        }
        return script;
    }

    private void megaprint(String source, TclScript result) {
        try {
            String xml = SimpleParserTests.serializeDocument(this.createXMLFromSource(source, result));
            System.out.println(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void runTestOn(String name) throws Exception {
        System.out.println("Running " + name);
        URL in = Activator.getDefault().getBundle().getEntry(name);
        URL ans = Activator.getDefault().getBundle().getEntry(String.valueOf(name) + ".xml");
        if (in == null || ans == null) {
            throw new Exception();
        }
        try {
            String content = this.getContents(in);
            TclScript s = SimpleTclParser.parse((String)content);
            Document docFromSource = this.createXMLFromSource(content, s);
            String resXML = SimpleParserTests.serializeDocument(docFromSource);
            String rightXML = this.getContents(ans);
            Document docFromFile = this.parseXML(rightXML);
            rightXML = SimpleParserTests.serializeDocument(docFromFile);
            SimpleParserTests.assertEquals((String)rightXML.trim(), (String)resXML.trim());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void _testAll() throws Exception {
        Enumeration e = Activator.getDefault().getBundle().getEntryPaths("rawtests/");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            System.out.println("found test " + o);
            this.runTestOn(o.toString());
        }
    }

    public void test0() throws Exception {
        this.runTestOn("rawtests/0.tcl");
    }

    public void test1() throws Exception {
        this.runTestOn("rawtests/1.tcl");
    }

    public void test2() throws Exception {
        this.runTestOn("rawtests/2.tcl");
    }

    public void test3() throws Exception {
        this.runTestOn("rawtests/3.tcl");
    }

    public void test4() throws Exception {
        this.runTestOn("rawtests/4.tcl");
    }

    public void test5() throws Exception {
        this.runTestOn("rawtests/5.tcl");
    }

    public void test6() throws Exception {
        this.runTestOn("rawtests/6.tcl");
    }

    public void test7() throws Exception {
        this.runTestOn("rawtests/simple0.tcl");
    }

    public void test8() throws Exception {
        this.runTestOn("rawtests/simple1.tcl");
    }

    public void test9() throws Exception {
        this.runTestOn("rawtests/simple3.tcl");
    }

    public void test10() throws Exception {
        this.runTestOn("rawtests/all.tcl");
    }

    public void test11() throws Exception {
        this.runTestOn("rawtests/a.tcl");
    }

    public void test12() throws Exception {
        String content = "\r\n\t    puts $a ; puts \"wow!\"\r";
        SimpleTclParser.parse((String)content);
    }

    public void test13() throws Exception {
        this.runTestOn("rawtests/7.tcl");
    }

    public void test14() throws Exception {
        this.runTestOn("rawtests/8.tcl");
    }

    public void test15() throws Exception {
        this.runTestOn("rawtests/9.tcl");
    }

    public void test16() throws Exception {
        this.runTestOn("rawtests/b.tcl");
    }

    public void test17() throws Exception {
        this.runTestOn("rawtests/c.tcl");
    }

    public void test18() throws Exception {
        this.runTestOn("rawtests/d.tcl");
    }

    public void test19() throws Exception {
        this.runTestOn("rawtests/e.tcl");
    }

    public void test20() throws Exception {
        this.runTestOn("rawtests/f.tcl");
    }

    public void test21() throws Exception {
        this.runTestOn("rawtests/g.tcl");
    }

    public void _testUtil() throws Exception {
        String content = "lreplace $list $index $index $newValue";
        TclScript s = SimpleTclParser.parse((String)content);
        this.print(s);
        this.megaprint(content, s);
    }
}

