/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.assist;

import junit.framework.Test;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.AbstractModelCompletionTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.internal.core.codeassist.RubySelectionEngine;

public class RubySelectionTests
extends AbstractModelCompletionTests {
    private static final String SELECTION_PROJECT = "RUBY_Selection";
    private static final ThinkRubySelectionEngine thinkEngine = new ThinkRubySelectionEngine();
    static /* synthetic */ Class class$0;

    public RubySelectionTests(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        this.PROJECT = this.setUpScriptProjectTo(SELECTION_PROJECT, "Selection");
        super.setUpSuite();
        RubySelectionTests.waitUntilIndexesReady();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
        RubySelectionTests.waitForAutoBuild();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(SELECTION_PROJECT);
        super.tearDownSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.core.tests.assist.RubySelectionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public String getCheckrbSource() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "check.rb");
        return cu.getSource();
    }

    public void selectionPosChecker0(int start, int end, boolean expRes, int expStart, int expEnd) throws ModelException {
        String source = this.getCheckrbSource();
        boolean res = thinkEngine.checkSelection(source, start, end);
        RubySelectionTests.assertEquals((boolean)expRes, (boolean)res);
        if (res) {
            RubySelectionTests.assertEquals((int)expStart, (int)thinkEngine.getActualStart());
            RubySelectionTests.assertEquals((int)expEnd, (int)thinkEngine.getActualEnd());
        }
    }

    public void selectionPosChecker1(String word) throws ModelException {
        String source = this.getCheckrbSource();
        int start = source.indexOf(word);
        RubySelectionTests.assertTrue((start != -1 ? 1 : 0) != 0);
        int end = start - 1;
        int i = 0;
        while (i < word.length()) {
            boolean res = thinkEngine.checkSelection(source, start + i, end + i);
            RubySelectionTests.assertEquals((boolean)true, (boolean)res);
            String sel = source.substring(thinkEngine.getActualStart(), thinkEngine.getActualEnd());
            RubySelectionTests.assertEquals((String)word, (String)sel);
            ++i;
        }
    }

    public void testSelectionPosChecker0() throws ModelException {
        this.selectionPosChecker0(0, 0, true, 0, 1);
    }

    public void testSelectionPosChecker1() throws ModelException {
        this.selectionPosChecker0(0, -1, true, 0, 3);
    }

    public void testSelectionPosChecker2() throws ModelException {
        this.selectionPosChecker1("FooClass");
    }

    public void testSelectionPosChecker3() throws ModelException {
        this.selectionPosChecker1("@a");
    }

    public void testSelectionPosChecker4() throws ModelException {
        this.selectionPosChecker1("@@a");
    }

    public void testSelectionPosChecker5() throws ModelException {
        this.selectionPosChecker1("foo1");
    }

    public void testSelectionPosChecker6() throws ModelException {
        this.selectionPosChecker1("cool?");
    }

    public void testSelectionPosChecker7() throws ModelException {
        this.selectionPosChecker1("hot!");
    }

    public void testSelectionPosChecker8() throws ModelException {
        this.selectionPosChecker1("**");
    }

    public void testSelectionPosChecker9() throws ModelException {
        this.selectionPosChecker1("$a");
    }

    public void testSelectionPosChecker10() throws ModelException {
        this.selectionPosChecker1("print");
    }

    public void testSelectionPosChecker11() throws ModelException {
        this.selectionPosChecker1("times");
    }

    public void testSelectionPosChecker12() throws ModelException {
        String src = this.getCheckrbSource();
        int pos = src.indexOf("5.*");
        this.selectionPosChecker0(pos + 2, pos + 1, true, pos + 2, pos + 3);
    }

    public void testSelectionPosChecker13() throws ModelException {
        this.selectionPosChecker1("4242");
    }

    public void testSelectionPosChecker15() throws ModelException {
        int pos = "def FooClass".length() + 5;
        this.selectionPosChecker0(pos + 2, pos + 4, false, 0, 0);
    }

    public void testSelectionPosChecker16() throws ModelException {
        int pos = "def FooClass".length() + 1;
        this.selectionPosChecker0(pos + 2, pos + 1, false, 0, 0);
    }

    public void testSelectionOnMethod() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("cool_method");
        IModelElement[] elements = cu.codeSelect(start + 1, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Bar").getMethod("cool_method");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnClassDeclaraion() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("Fooo");
        IModelElement[] elements = cu.codeSelect(start + 1, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IType type = cu.getType("Fooo");
        RubySelectionTests.assertNotNull((Object)type);
        RubySelectionTests.assertEquals((Object)type, (Object)elements[0]);
    }

    public void testSelectionOnClassUsage() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("Bar");
        IModelElement[] elements = cu.codeSelect(start + 1, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)2, (int)elements.length);
    }

    public void testSelectionOnMethodDeclaration() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("doo");
        IModelElement[] elements = cu.codeSelect(start + 1, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Fooo").getMethod("doo");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnMethod2() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("Bar.new.cool_method");
        IModelElement[] elements = cu.codeSelect(start + "Bar.new.".length() + 2, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Bar").getMethod("cool_method");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnLocalVariable() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("ff = Fooo.new") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
    }

    public void testSelectionOnLocalVariableMethodNIM() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method1.rb");
        String source = cu.getSource();
        int start = source.indexOf("f.doo");
        IModelElement[] elements = cu.codeSelect(start + 3, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Fooo").getMethod("doo");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnMethod2_1() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method2.rb");
        String source = cu.getSource();
        int start = source.indexOf("boz.dining_philosopher") + 5;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Foo").getMethod("dining_philosopher");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnMethod2_2() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method2.rb");
        String source = cu.getSource();
        int start = source.indexOf("ultimate_answer") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getType("Foo").getMethod("ultimate_answer");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnMethod3_2() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_method3.rb");
        String source = cu.getSource();
        int start = source.indexOf("megathing") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
        IMethod method = cu.getMethod("megathing");
        RubySelectionTests.assertNotNull((Object)method);
        RubySelectionTests.assertEquals((Object)method, (Object)elements[0]);
    }

    public void testSelectionOnSuper() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_super.rb");
        String source = cu.getSource();
        int start = source.indexOf("super") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
    }

    public void testBug185487() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "dsl/behaviour.rb");
        String source = cu.getSource();
        int start = source.indexOf("example_finished") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
    }

    public void testBug193105() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "b193105.rb");
        String source = cu.getSource();
        int start = source.indexOf("instance_variable_set") + 1;
        IModelElement[] elements = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertEquals((int)1, (int)elements.length);
    }

    public void testBug194721() throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", "selection_on_var.rb");
        String source = cu.getSource();
        int start = source.lastIndexOf("boolean");
        IModelElement[] before = cu.codeSelect(start, 0);
        RubySelectionTests.assertNotNull((Object)before);
        RubySelectionTests.assertEquals((int)1, (int)before.length);
        IModelElement[] after = cu.codeSelect(start + "boolean".length(), 0);
        RubySelectionTests.assertNotNull((Object)after);
        RubySelectionTests.assertEquals((int)1, (int)after.length);
    }

    public void executeTest(String module, int offset, int length) throws ModelException {
        ISourceModule cu = this.getSourceModule(SELECTION_PROJECT, "src", module);
        if (offset == 657) {
            System.out.println();
        }
        IModelElement[] elements = cu.codeSelect(offset, length);
        RubySelectionTests.assertNotNull((Object)elements);
        RubySelectionTests.assertTrue((elements.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < elements.length) {
            RubySelectionTests.assertNotNull((Object)elements[i]);
            ++i;
        }
    }

    private static class ThinkRubySelectionEngine
    extends RubySelectionEngine {
        public boolean checkSelection(String source, int start, int end) {
            return super.checkSelection(source, start, end);
        }

        public int getActualStart() {
            return this.actualSelectionStart;
        }

        public int getActualEnd() {
            return this.actualSelectionEnd;
        }
    }
}

