/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.parser;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;

public abstract class AbstractASTTest
extends AbstractModelTests {
    protected static final CountingProblemReporter problems = new CountingProblemReporter();

    public AbstractASTTest(String testProjectName, String name) {
        super(testProjectName, name);
    }

    public AbstractASTTest(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    protected ModuleDeclaration getAST(String content) {
        problems.reset();
        return DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature").parse(null, content.toCharArray(), (IProblemReporter)problems);
    }

    protected ASTNode getNodeAt(ASTNode root, final int start, final int end) throws Exception {
        AbstractASTTest.assertTrue((start != -1 || end != -1 ? 1 : 0) != 0);
        final ASTNode[] result = new ASTNode[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (!(node.sourceStart() != start && start != -1 || node.sourceEnd() != end && end != -1)) {
                    if (result[0] != null && !(result[0] instanceof ModuleDeclaration)) {
                        throw new RuntimeException("Two different nodes on " + start + ":" + end);
                    }
                    result[0] = node;
                }
                return true;
            }
        };
        root.traverse(visitor);
        return result[0];
    }

    protected abstract Class getExpectedClass();

    protected ASTNode checkNode(String content, int start, int end) throws Exception {
        ModuleDeclaration ast = this.getAST(content);
        AbstractASTTest.assertNotNull((Object)ast);
        if (problems.getCount() != 0) {
            throw new RuntimeException(problems.info());
        }
        ASTNode nodeAt = this.getNodeAt((ASTNode)ast, start, end);
        AbstractASTTest.assertNotNull((Object)nodeAt);
        AbstractASTTest.assertEquals((Object)this.getExpectedClass(), nodeAt.getClass());
        return nodeAt;
    }

    protected static class CountingProblemReporter
    extends AbstractProblemReporter {
        public int count = 0;
        public String lastInfo = "<no errors>";

        protected CountingProblemReporter() {
        }

        public void reset() {
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public String info() {
            return this.lastInfo;
        }

        public IMarker reportProblem(IProblem problem) throws CoreException {
            ++this.count;
            this.lastInfo = problem.getMessage();
            return null;
        }
    }
}

