/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.parser.jruby;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

public class AST2StringVisitor
extends ASTVisitor {
    private StringWriter writer = new StringWriter();
    private CorePrinter printer = new CorePrinter((Writer)this.writer);
    private String indent = "";

    public boolean visitGeneral(ASTNode node) throws Exception {
        String str = node.debugString();
        this.printer.println(String.valueOf(this.indent) + "+" + str);
        this.indent = String.valueOf(this.indent) + "  ";
        return super.visitGeneral(node);
    }

    private static String simplifyClassName(String name) {
        int pos = name.lastIndexOf(46);
        return name.substring(pos + 1);
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.printer.println(String.valueOf(this.indent) + "-" + AST2StringVisitor.simplifyClassName(node.getClass().getName()));
        super.endvisitGeneral(node);
    }

    public String getResult() {
        this.printer.flush();
        this.printer.close();
        return this.writer.getBuffer().toString();
    }
}

