/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.parser.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.ruby.core.tests.Activator;
import org.eclipse.dltk.ruby.core.tests.parser.jruby.AST2StringVisitor;

public class ParserSuite
extends TestSuite {
    public ParserSuite(String testsDirectory) {
        super(testsDirectory);
        Enumeration entryPaths = Activator.getDefault().getBundle().getEntryPaths(testsDirectory);
        while (entryPaths.hasMoreElements()) {
            String path = (String)entryPaths.nextElement();
            if (path.endsWith(".exp")) continue;
            URL entry = Activator.getDefault().getBundle().getEntry(path);
            try {
                entry.openStream().close();
            }
            catch (Exception exception) {
                continue;
            }
            int pos = path.lastIndexOf(47);
            String name = pos >= 0 ? path.substring(pos + 1) : path;
            pos = path.lastIndexOf(46);
            final String cleanPath = pos >= 0 ? path.substring(0, pos) : path;
            this.addTest((Test)new TestCase(name){

                public void setUp() {
                }

                protected void runTest() throws Throwable {
                    HashMap map = new HashMap();
                    String input = ParserSuite.this.loadInput(String.valueOf(cleanPath) + ".rb", map);
                    String output = ParserSuite.this.loadOutput(String.valueOf(cleanPath) + ".exp", map);
                    ModuleDeclaration module = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature").parse((String.valueOf(cleanPath) + ".rb").toCharArray(), input.toCharArray(), null);
                    1.assertNotNull((Object)module);
                    AST2StringVisitor vis = new AST2StringVisitor();
                    module.traverse((ASTVisitor)vis);
                    String fact = vis.getResult();
                    if (!"success".equals(output.trim())) {
                        1.assertEquals((String)output, (String)fact);
                    }
                }
            });
        }
    }

    public static String loadContent(String path) throws IOException {
        Activator.getDefault();
        InputStream stream = Activator.openResource(path);
        int length = stream.available();
        byte[] data = new byte[length];
        stream.read(data);
        stream.close();
        return new String(data, "utf-8");
    }

    private String loadInput(String path, Map map) throws IOException {
        String content = ParserSuite.loadContent(path);
        StringBuffer result = new StringBuffer();
        char[] charArray = content.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c > 'z') {
                map.put(new Character(c), new Integer(result.length()));
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private String loadOutput(String path, Map map) throws IOException {
        String content = ParserSuite.loadContent(path);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c > '~') {
                Integer pos = (Integer)map.get(new Character(c));
                Assert.isNotNull((Object)pos);
                result.append(pos);
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static interface IAssertion {
        public void check();
    }
}

