/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.parser.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.ruby.core.tests.Activator;
import org.eclipse.dltk.ruby.internal.parser.JRubySourceParser;
import org.osgi.framework.Bundle;

public class ZippedParserSuite
extends TestSuite {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZippedParserSuite(String testsZip) {
        super(testsZip);
        try {
            ZipFile zipFile = new ZipFile(AbstractModelTests.storeToMetadata((Bundle)Activator.getDefault().getBundle(), (String)"parser.zip", (String)testsZip));
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    final String fileName = entry.getName();
                    final String content = ZippedParserSuite.loadContent(zipFile.getInputStream(entry));
                    this.addTest((Test)new TestCase(entry.getName()){

                        public void setUp() {
                        }

                        protected void runTest() throws Throwable {
                            JRubySourceParser.setSilentState((boolean)false);
                            ModuleDeclaration module = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature").parse(fileName.toCharArray(), content.toCharArray(), null);
                            1.assertNotNull((Object)module);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                zipFile.close();
                throw throwable;
            }
            {
                Object var7_11 = null;
                zipFile.close();
                return;
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String loadContent(InputStream stream) throws IOException {
        String string;
        try {
            int length = stream.available();
            byte[] data = new byte[length];
            stream.read(data);
            string = new String(data, "utf-8");
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
        return string;
    }
}

