/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceModuleInfoCacheTest
extends AbstractModelTests {
    private static final String PROJECT = "resource1";
    private static final String AST = "ast";
    static /* synthetic */ Class class$0;

    public SourceModuleInfoCacheTest(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.core.tests.resources.SourceModuleInfoCacheTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpScriptProject(PROJECT);
        SourceModuleInfoCacheTest.waitUntilIndexesReady();
    }

    protected void tearDown() throws Exception {
        this.deleteProject(PROJECT);
        super.tearDown();
    }

    private IScriptModel getModel() {
        return ModelManager.getModelManager().getModel();
    }

    private ISourceModuleInfoCache getSourceModuleInfoCache() {
        return ModelManager.getModelManager().getSourceModuleInfoCache();
    }

    public void testCacheResourceChanged() throws CoreException {
        ISourceModuleInfoCache getSourceModuleInfoCache;
        IScriptModel model = this.getModel();
        IScriptProject project = model.getScriptProject(PROJECT);
        ISourceModule module1 = (ISourceModule)project.findElement((IPath)new Path("resource001.rb"));
        ISourceModuleInfoCache cache = getSourceModuleInfoCache = this.getSourceModuleInfoCache();
        SourceParserUtil.getModuleDeclaration((ISourceModule)module1, null);
        ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = cache.get(module1);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry.get((Object)AST));
        IFile file = project.getProject().getFile("resource001.rb");
        String source = String.valueOf(module1.getSource()) + "\n\n" + "#END OF FILE";
        file.setContents((InputStream)new ByteArrayInputStream(source.getBytes()), true, false, null);
        cacheEntry = cache.get(module1);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry);
        SourceModuleInfoCacheTest.assertNull((Object)cacheEntry.get((Object)AST));
    }

    public void testCacheResourceDeleted() throws CoreException {
        IScriptModel model = this.getModel();
        IScriptProject project = model.getScriptProject(PROJECT);
        ISourceModule module1 = (ISourceModule)project.findElement((IPath)new Path("resource001.rb"));
        ISourceModuleInfoCache cache = this.getSourceModuleInfoCache();
        SourceParserUtil.getModuleDeclaration((ISourceModule)module1, null);
        ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = cache.get(module1);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry.get((Object)AST));
        project.getProject().getFile("resource001.rb").delete(true, null);
        cacheEntry = cache.get(module1);
        SourceModuleInfoCacheTest.assertNotNull((Object)cacheEntry);
        SourceModuleInfoCacheTest.assertNull((Object)cacheEntry.get((Object)AST));
    }
}

