/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.search.mixin;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.IDLTKSearchConstants;
import org.eclipse.dltk.core.tests.model.AbstractDLTKSearchTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;

public class MixinModelManipulationTests
extends AbstractDLTKSearchTests
implements IDLTKSearchConstants {
    private static final String PROJECT_NAME = "mixins";
    static /* synthetic */ Class class$0;

    public MixinModelManipulationTests(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.core.tests.search.mixin.MixinModelManipulationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.up();
        MixinModelManipulationTests.waitUntilIndexesReady();
        this.buildAll();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECT_NAME);
        super.tearDownSuite();
    }

    private void up() throws Exception {
        if (this.SCRIPT_PROJECT != null) {
            this.deleteProject(this.SCRIPT_PROJECT.getElementName());
        }
        this.SCRIPT_PROJECT = this.setUpScriptProject(PROJECT_NAME);
    }

    private void buildAll() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
        MixinModelManipulationTests.waitForAutoBuild();
    }

    public void REM_testTotalKeysCount() {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        String[] keys = model.findKeys("*");
        MixinModelManipulationTests.assertEquals((int)26, (int)keys.length);
    }

    public void testForGhosts() {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        String[] keys = model.findKeys("*ghost*");
        MixinModelManipulationTests.assertEquals((int)0, (int)keys.length);
    }

    public void testModuleDeletion() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("Foo");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] objs = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertNotNull((Object)objs);
        MixinModelManipulationTests.assertEquals((int)2, (int)objs.length);
        ISourceModule sourceModule = this.getSourceModule(PROJECT_NAME, "src", "src2.rb");
        sourceModule.delete(true, null);
        this.buildAll();
        Object[] objs2 = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertEquals((int)1, (int)objs2.length);
    }

    public void testFatalModuleDeletion() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("D");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] objs = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertNotNull((Object)objs);
        MixinModelManipulationTests.assertEquals((int)2, (int)objs.length);
        ISourceModule sourceModule = this.getSourceModule(PROJECT_NAME, "src", "src1.rb");
        sourceModule.delete(true, null);
        this.buildAll();
        mixinElement = model.get("D");
        MixinModelManipulationTests.assertNull((Object)mixinElement);
    }

    public void REM_testExistentClassExtension() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("Foo");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] objs = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertEquals((int)2, (int)objs.length);
        IScriptFolder scriptFolder = this.getScriptFolder(PROJECT_NAME, "src", (IPath)new Path(""));
        String contents = "class Foo\n def bar\n end\n end\n";
        scriptFolder.createSourceModule("MoreFoo.rb", contents, true, null);
        this.buildAll();
        mixinElement = model.get("Foo");
        Object[] objs2 = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertEquals((int)2, (int)objs2.length);
    }

    public void testNewClassAddition() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("Buzzy");
        MixinModelManipulationTests.assertNull((Object)mixinElement);
        IScriptFolder scriptFolder = this.getScriptFolder(PROJECT_NAME, "src", (IPath)new Path(""));
        String contents = "class Buzzy\n    def myFyb\n     end\n end\n";
        scriptFolder.createSourceModule("Buzzy.rb", contents, true, null);
        this.buildAll();
        mixinElement = model.get("Buzzy");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] objs2 = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertEquals((int)1, (int)objs2.length);
    }

    public void testBuildpathAddition() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("Cat");
        MixinModelManipulationTests.assertNull((Object)mixinElement);
        IBuildpathEntry[] rawBuildpath = this.SCRIPT_PROJECT.getRawBuildpath();
        IBuildpathEntry[] newRawBuildpath = new IBuildpathEntry[rawBuildpath.length + 1];
        System.arraycopy(rawBuildpath, 0, newRawBuildpath, 0, rawBuildpath.length);
        newRawBuildpath[rawBuildpath.length] = DLTKCore.newSourceEntry((IPath)new Path("/mixins/src3"));
        this.SCRIPT_PROJECT.setRawBuildpath(newRawBuildpath, null);
        this.buildAll();
        mixinElement = model.get("Cat");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] allObjects = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertTrue((allObjects.length > 0 ? 1 : 0) != 0);
    }

    public void testBuildpathDeletion() throws Exception {
        MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());
        IMixinElement mixinElement = model.get("Dragon");
        MixinModelManipulationTests.assertNotNull((Object)mixinElement);
        Object[] objs = mixinElement.getAllObjects();
        MixinModelManipulationTests.assertNotNull((Object)objs);
        IBuildpathEntry[] rawBuildpath = this.SCRIPT_PROJECT.getRawBuildpath();
        IBuildpathEntry[] newRawBuildpath = new IBuildpathEntry[rawBuildpath.length - 1];
        boolean found = false;
        int i = 0;
        int j = 0;
        while (i < rawBuildpath.length) {
            if (!rawBuildpath[i].getPath().toString().endsWith("src2")) {
                newRawBuildpath[j++] = rawBuildpath[i];
            } else {
                found = true;
            }
            ++i;
        }
        MixinModelManipulationTests.assertTrue((String)"Buildpath should contain source folder src2", (boolean)found);
        this.SCRIPT_PROJECT.setRawBuildpath(newRawBuildpath, null);
        this.buildAll();
        mixinElement = model.get("Dragon");
        MixinModelManipulationTests.assertNull((Object)mixinElement);
    }
}

