/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.search.mixin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.eclipse.dltk.ruby.core.tests.Activator;
import org.eclipse.dltk.ruby.core.tests.search.mixin.IAssertion;
import org.eclipse.dltk.ruby.core.tests.search.mixin.MixinTest;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;

public class MixinTestsSuite
extends TestSuite {
    private final MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());

    public MixinTestsSuite(String testsDirectory) {
        super(testsDirectory);
        final MixinTest tests = new MixinTest("Ruby Mixin Tests");
        try {
            tests.setUpSuite();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Enumeration entryPaths = Activator.getDefault().getBundle().getEntryPaths(testsDirectory);
        while (entryPaths.hasMoreElements()) {
            final String path = (String)entryPaths.nextElement();
            URL entry = Activator.getDefault().getBundle().getEntry(path);
            try {
                entry.openStream().close();
            }
            catch (Exception exception) {
                continue;
            }
            int pos = path.lastIndexOf(47);
            String name = pos >= 0 ? path.substring(pos + 1) : path;
            String x = path.substring(0, pos);
            pos = x.lastIndexOf(47);
            if (pos >= 0) {
                x.substring(pos + 1);
            }
            this.addTest((Test)new TestCase(name){
                private Collection assertions = new ArrayList();

                public void setUp() {
                }

                protected void runTest() throws Throwable {
                    String content = MixinTestsSuite.this.loadContent(path);
                    String[] lines = content.split("\n");
                    int lineOffset = 0;
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i].trim();
                        int pos = line.indexOf("##");
                        if (pos >= 0) {
                            StringTokenizer tok = new StringTokenizer(line.substring(pos + 2));
                            String test = tok.nextToken();
                            if ("exit".equals(test)) {
                                return;
                            }
                            if ("get".equals(test)) {
                                String key = tok.nextToken();
                                this.assertions.add(new GetElementAssertion(key, MixinTestsSuite.this.model));
                            }
                        }
                        lineOffset += lines[i].length() + 1;
                        ++i;
                    }
                    Assert.isLegal((this.assertions.size() > 0 ? 1 : 0) != 0);
                    tests.executeTest(this.assertions);
                }

                class GetElementAssertion
                implements IAssertion {
                    private final String key;
                    private MixinModel model;

                    public GetElementAssertion(String key, MixinModel model) {
                        this.key = key;
                        this.model = model;
                    }

                    public void check() throws Exception {
                        this.model = new MixinModel(RubyLanguageToolkit.getDefault());
                        IMixinElement mixinElement = this.model.get(this.key);
                        if (mixinElement == null) {
                            throw new AssertionFailedError("Key " + this.key + " not found");
                        }
                        Object[] allObjects = mixinElement.getAllObjects();
                        if (allObjects == null && allObjects.length > 0) {
                            throw new AssertionFailedError("Key " + this.key + " has null or empty object set");
                        }
                        int i = 0;
                        while (i < allObjects.length) {
                            if (allObjects[i] == null) {
                                throw new AssertionFailedError("Key " + this.key + " has null object at index " + i);
                            }
                            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
                            if (info.getObject() == null) {
                                throw new AssertionFailedError("Key " + this.key + " has info with a null object at index " + i + " (kind=" + info.getKind() + ")");
                            }
                            ++i;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadContent(String path) throws IOException {
        StringBuffer buffer = new StringBuffer();
        InputStream input = null;
        try {
            Activator.getDefault();
            input = Activator.openResource(path);
            char[] buff = new char[4096];
            int len = 0;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((len = reader.read(buff)) != -1) {
                if (len <= 0) continue;
                buffer.append(buff, 0, len);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (input == null) throw throwable;
            input.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
            if (input == null) return buffer.toString();
        }
        input.close();
        return buffer.toString();
    }
}

