/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.search.mixin;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.tests.model.AbstractDLTKSearchTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;

public class ThreadedMixinTests
extends AbstractDLTKSearchTests {
    private static final String PROJECT_NAME = "mixins";
    private static String fgLastUsedID;
    static /* synthetic */ Class class$0;

    public ThreadedMixinTests(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.core.tests.search.mixin.ThreadedMixinTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.up();
        ThreadedMixinTests.waitUntilIndexesReady();
        this.buildAll();
    }

    private void buildAll() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECT_NAME);
        super.tearDownSuite();
    }

    protected String createUniqueId(IInterpreterInstallType InterpreterType) {
        String id = null;
        while (InterpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    private void up() throws Exception {
        if (this.SCRIPT_PROJECT != null) {
            this.deleteProject(this.SCRIPT_PROJECT.getElementName());
        }
        this.SCRIPT_PROJECT = this.setUpScriptProject(PROJECT_NAME);
    }

    public void testMultiAccess() throws Exception {
        int count = 10;
        String[] findKeys = RubyMixinModel.getRawInstance().findKeys("*");
        Thread[] threads = new Thread[count];
        Access[] access = new Access[count];
        int d = findKeys.length / count;
        int i = 0;
        while (i < count) {
            Access a;
            if (i != count - 1) {
                access[i] = a = new Access(findKeys, d * i, d * (i + 1), 1);
                threads[i] = new Thread(a);
            } else {
                access[i] = a = new Access(findKeys, d * i, findKeys.length, 10);
                threads[i] = new Thread(a);
            }
            ++i;
        }
        long s = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < threads.length) {
            threads[i2].start();
            ++i2;
        }
        i2 = 0;
        while (i2 < threads.length) {
            threads[i2].join(100000L);
            ThreadedMixinTests.assertTrue((boolean)access[i2].finish);
            ++i2;
        }
        long e = System.currentTimeMillis();
        System.out.println("time:" + Long.toString(e - s));
    }

    class Access
    implements Runnable {
        private int start = 0;
        private int stop = 0;
        private int cycles = 0;
        private String[] keys;
        public boolean finish = false;

        public Access(String[] keys, int start, int stop, int cycles) {
            this.start = start;
            this.stop = stop;
            this.cycles = cycles;
            this.keys = keys;
        }

        public void run() {
            RubyMixinModel instance = RubyMixinModel.getInstance();
            int i = 0;
            while (i < this.cycles) {
                int j = 0;
                while (j < this.stop - this.start) {
                    instance.createRubyElement(this.keys[this.start + j]);
                    ++j;
                }
                ++i;
            }
            this.finish = true;
            System.out.println("Finished");
        }
    }
}

