/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.text.completion;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.AbstractModelCompletionTests;
import org.eclipse.dltk.core.tests.model.CompletionTestsRequestor;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class RubyCompletionTests
extends AbstractModelCompletionTests {
    static /* synthetic */ Class class$0;

    public RubyCompletionTests(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        this.PROJECT = this.setUpScriptProject("completion");
        RubyCompletionTests.waitUntilIndexesReady();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
        RubyCompletionTests.waitForAutoBuild();
        super.setUpSuite();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("completion");
        super.tearDownSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.core.tests.text.completion.RubyCompletionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void testCompletion001() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "new.rb");
        String str = cu.getSource();
        String completeBehind = "Foo.new.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion002() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "inner.rb");
        String str = cu.getSource();
        String completeBehind = "Foo42::";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion003() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c1.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion004() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c2.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion005() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c3.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion006() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c4.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion007() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "colon1.rb");
        String str = cu.getSource();
        String completeBehind = "::";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("Mine42") != -1 && requestor.getResults().indexOf("Mix42") != -1 ? 1 : 0) != 0);
    }

    public void testCompletion008() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "colon2.rb");
        String str = cu.getSource();
        String completeBehind = "::";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("Mine") != -1 && requestor.getResults().indexOf("Mix") != -1 ? 1 : 0) != 0);
    }

    public void testCompletion009() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "colon3.rb");
        String str = cu.getSource();
        String completeBehind = "Min";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("Mine") != -1 ? 1 : 0) != 0);
    }

    public void testCompletion010() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "var1.rb");
        String str = cu.getSource();
        String completeBehind = "@a";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion011() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "var2.rb");
        String str = cu.getSource();
        String completeBehind = "@a";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion012() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "var3.rb");
        String str = cu.getSource();
        String completeBehind = "@@a";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion013() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "const1.rb");
        String str = cu.getSource();
        String completeBehind = "Mega";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion014() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c5.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion015() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c6.rb");
        String str = cu.getSource();
        String completeBehind = "t.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion016() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c7.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion017() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "singl1.rb");
        String str = cu.getSource();
        String completeBehind = "Foo66.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("cool") != -1 ? 1 : 0) != 0);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("cool2") != -1 ? 1 : 0) != 0);
    }

    public void testCompletion018() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "singl2.rb");
        String str = cu.getSource();
        String completeBehind = "Foo66.cool2.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion019() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c8.rb");
        String str = cu.getSource();
        String completeBehind = "@categ";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion020() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c0.rb");
        String str = cu.getSource();
        String completeBehind = "::";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
    }

    public void testCompletion021() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c67.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion022() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "object.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion023() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b181387.rb");
        String str = cu.getSource();
        String completeBehind = "t.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion024() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180869.rb");
        String str = cu.getSource();
        String completeBehind = ".x";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion025() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180152.rb");
        String str = cu.getSource();
        String completeBehind = "::x";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion026() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "c9.rb");
        String str = cu.getSource();
        String completeBehind = "fo";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("foo") != -1 ? 1 : 0) != 0);
    }

    public void testCompletion027() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "inside_block.rb");
        String str = cu.getSource();
        String completeBehind = "v.tu";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion028() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180149.rb");
        String str = cu.getSource();
        String completeBehind = "p";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion029() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180143.rb");
        String str = cu.getSource();
        String completeBehind = "arg3['sdsd'] = ";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion030() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180146.rb");
        String str = cu.getSource();
        String completeBehind = "ff g";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion031() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180160.rb");
        String str = cu.getSource();
        String completeBehind = "_f";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion032() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180157.rb");
        String str = cu.getSource();
        String completeBehind = "puts v";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion033() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180162_01.rb");
        String str = cu.getSource();
        String completeBehind = "@data[@i";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion034() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180162_02.rb");
        String str = cu.getSource();
        String completeBehind = "@data[@";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion035() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180163.rb");
        String str = cu.getSource();
        String completeBehind = "xx";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion036() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180165.rb");
        String str = cu.getSource();
        String completeBehind = "t";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion037() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180155.rb");
        String str = cu.getSource();
        String completeBehind = "Test.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion038Keywords() throws ModelException {
        ISourceModule cu = this.getSourceModule("completion", "src", "b180158.rb");
        String str = cu.getSource();
        String[] keyWords = str.split("\n");
        int i = 0;
        while (i < keyWords.length) {
            keyWords[i] = keyWords[i].trim();
            ++i;
        }
        i = 0;
        while (i < keyWords.length) {
            CompletionTestsRequestor requestor = new CompletionTestsRequestor();
            String completeBehind = keyWords[i];
            int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
            RubyCompletionTests.waitForAutoBuild();
            cu.codeComplete(--cursorLocation, (CompletionRequestor)requestor);
            String completionResults = requestor.getResults();
            RubyCompletionTests.assertTrue((completionResults.length() > 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testCompletion039() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180152.rb");
        String str = cu.getSource();
        String completeBehind = "::";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion040() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b182532.rb");
        String str = cu.getSource();
        String completeBehind = "x.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion041() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b182532.rb");
        String str = cu.getSource();
        String completeBehind = "y.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion042() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b191439.rb");
        String str = cu.getSource();
        String completeBehind = ".se";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int methodOccurence = completionResults.indexOf("send");
        RubyCompletionTests.assertTrue((methodOccurence > -1 ? 1 : 0) != 0);
    }

    public void testCompletion043() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b186509.rb");
        String str = cu.getSource();
        String completeBehind = ".n";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int methodOccurence = completionResults.indexOf("new(i,g,d,s,a,r)");
        RubyCompletionTests.assertTrue((methodOccurence > -1 ? 1 : 0) != 0);
    }

    public void testCompletion044() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b185650.rb");
        String str = cu.getSource();
        String completeBehind = "l.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        Vector<String> methods = new Vector<String>();
        int lastElementsOccurance = 0;
        while ((lastElementsOccurance = completionResults.indexOf("element:", lastElementsOccurance)) > -1) {
            int lastElementsIndex = lastElementsOccurance + new String("element:").length();
            lastElementsOccurance = completionResults.indexOf(" ", lastElementsOccurance);
            methods.add(completionResults.substring(lastElementsIndex, lastElementsOccurance));
        }
        Vector<String> relevances = new Vector<String>();
        int lastRelevanceOccurance = 0;
        while (lastRelevanceOccurance > -1) {
            lastRelevanceOccurance = completionResults.indexOf("relevance:", lastRelevanceOccurance);
            int lastRelevanceIndex = lastRelevanceOccurance + new String("relevance:").length();
            if ((lastRelevanceOccurance = completionResults.indexOf("\n", lastRelevanceOccurance)) > -1) {
                relevances.add(completionResults.substring(lastRelevanceIndex, lastRelevanceOccurance));
                continue;
            }
            relevances.add(completionResults.substring(lastRelevanceIndex));
        }
        RubyCompletionTests.assertTrue((methods.size() == relevances.size() ? 1 : 0) != 0);
    }

    public void testCompletion045() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180383.rb");
        String str = cu.getSource();
        String completeBehind = "File.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion046() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180383.rb");
        String str = cu.getSource();
        String completeBehind = "File.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion047() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180382.rb");
        String str = cu.getSource();
        String completeBehind = "File.ex";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion048() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180372.rb");
        String str = cu.getSource();
        String completeBehind = "@f";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion049() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180854.rb");
        String str = cu.getSource();
        String completeBehind = "y.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion050() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b192388.rb");
        String str = cu.getSource();
        String completeBehind = "self.m";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion051() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180388_03.rb");
        String str = cu.getSource();
        String completeBehind = ".new; @parser.s";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion052() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b186510.rb");
        String str = cu.getSource();
        String completeBehind = "z2.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion053() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b183950.rb");
        String str = cu.getSource();
        String completeBehind = "t.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion054() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b185643_01.rb");
        String str = cu.getSource();
        String completeBehind = "val.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        if (completionResults != null) {
            RubyCompletionTests.assertTrue((completionResults.indexOf(">>") == -1 ? 1 : 0) != 0);
            RubyCompletionTests.assertTrue((completionResults.indexOf("[]=") > -1 ? 1 : 0) != 0);
        }
    }

    public void testCompletion055() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b185643_02.rb");
        String str = cu.getSource();
        String completeBehind = "val.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        if (completionResults != null) {
            RubyCompletionTests.assertTrue((completionResults.indexOf(">>") > -1 ? 1 : 0) != 0);
            RubyCompletionTests.assertTrue((completionResults.indexOf("[]=") == -1 ? 1 : 0) != 0);
        }
    }

    public void testCompletion056() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180397.rb");
        String str = cu.getSource();
        String completeBehind = "@body.i";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion057() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b198654.rb");
        String str = cu.getSource();
        String completeBehind = "4.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("%") > -1 ? 1 : 0) != 0);
    }

    public void testCompletion058() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b198704.rb");
        String str = cu.getSource();
        String completeBehind = "--1.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("%") > -1 ? 1 : 0) != 0);
    }

    public void testCompletion059() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b209354.rb");
        String str = cu.getSource();
        String completeBehind = "w.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().length() > 0 ? 1 : 0) != 0);
    }

    public void testCompletion060_FAILS() throws ModelException {
        if (this.notYetImplemented()) {
            return;
        }
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b193898.rb");
        String str = cu.getSource();
        String completeBehind = "as.methods.so";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        RubyCompletionTests.assertTrue((requestor.getResults().indexOf("sort") > -1 ? 1 : 0) != 0);
    }

    public void testCompletion061_FAILS() throws ModelException {
        if (this.notYetImplemented()) {
            return;
        }
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b194725.rb");
        String str = cu.getSource();
        String completeBehind = "__FILE_";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        int lineIndex = requestor.getResults().indexOf("__LINE__");
        RubyCompletionTests.assertTrue((lineIndex == -1 ? 1 : 0) != 0);
    }

    public void REM_testCompletion062_FAILS_ON_WINDOWS() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b195463.rb");
        String str = cu.getSource();
        String completeBehind = "String.new.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        int resultsLength = requestor.getResults().length();
        RubyCompletionTests.assertTrue((resultsLength > 0 ? 1 : 0) != 0);
    }

    public void testCompletion063() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b196781.rb");
        String str = cu.getSource();
        String completeBehind = "protecte";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        int resultsLength = requestor.getResults().length();
        RubyCompletionTests.assertTrue((resultsLength > 0 ? 1 : 0) != 0);
    }

    public void testCompletion064_FAILS() throws ModelException {
        if (this.notYetImplemented()) {
            return;
        }
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b198381.rb");
        String str = cu.getSource();
        String completeBehind = "med";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int methodIndex = completionResults.indexOf("medved(a,b,c,d)");
        RubyCompletionTests.assertTrue((methodIndex > -1 ? 1 : 0) != 0);
    }

    public void REM_testCompletion065_FAILS_IN_EDITOR() throws ModelException {
        if (this.notYetImplemented()) {
            return;
        }
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180167.rb");
        String str = cu.getSource();
        String completeBehind = "x";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int resultsLength = completionResults.length();
        RubyCompletionTests.assertTrue((resultsLength > 0 ? 1 : 0) != 0);
    }

    public void testCompletion066() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b180147.rb");
        String str = cu.getSource();
        String completeBehind = ".";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int resultsLength = completionResults.length();
        RubyCompletionTests.assertTrue((resultsLength > 0 ? 1 : 0) != 0);
    }

    public void testCompletion067() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b194564.rb");
        String str = cu.getSource();
        String completeBehind = "3.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int resultsLength = completionResults.length();
        RubyCompletionTests.assertTrue((resultsLength > 0 ? 1 : 0) != 0);
    }

    public void testCompletion068() throws ModelException {
        CompletionTestsRequestor requestor = new CompletionTestsRequestor();
        ISourceModule cu = this.getSourceModule("completion", "src", "b191448.rb");
        String str = cu.getSource();
        String completeBehind = "str1.";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        RubyCompletionTests.waitForAutoBuild();
        cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
        String completionResults = requestor.getResults();
        int scanfIndex = completionResults.indexOf("scanf");
        RubyCompletionTests.assertTrue((scanfIndex == -1 ? 1 : 0) != 0);
    }
}

