/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.typeinference;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.core.tests.Activator;
import org.eclipse.dltk.ruby.core.tests.typeinference.IAssertion;
import org.eclipse.dltk.ruby.core.tests.typeinference.TypeInferenceTest;
import org.eclipse.dltk.ruby.typeinference.OffsetTargetedASTVisitor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ITypeInferencer;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.dltk.ti.types.RecursionTypeCall;

public class TypeInferenceSuite
extends TestSuite {
    public TypeInferenceSuite(String testsDirectory) {
        super(testsDirectory);
        Enumeration entryPaths = Activator.getDefault().getBundle().getEntryPaths(testsDirectory);
        while (entryPaths.hasMoreElements()) {
            final String path = (String)entryPaths.nextElement();
            URL entry = Activator.getDefault().getBundle().getEntry(path);
            try {
                entry.openStream().close();
            }
            catch (Exception exception) {
                continue;
            }
            int pos = path.lastIndexOf(47);
            final String name = pos >= 0 ? path.substring(pos + 1) : path;
            String x = path.substring(0, pos);
            pos = x.lastIndexOf(47);
            final String folder = pos >= 0 ? x.substring(pos + 1) : x;
            this.addTest((Test)new TestCase(name){
                private Collection assertions = new ArrayList();

                public void setUp() {
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void runTest() throws Throwable {
                    String content = TypeInferenceSuite.this.loadContent(path);
                    String[] lines = content.split("\n");
                    int lineOffset = 0;
                    int i = 0;
                    while (true) {
                        if (i >= lines.length) {
                            if (this.assertions.size() != 0) break;
                            return;
                        }
                        String line = lines[i].trim();
                        int pos = line.indexOf("##");
                        if (pos >= 0) {
                            String correctClassRef;
                            String arrow;
                            int namePos;
                            StringTokenizer tok = new StringTokenizer(line.substring(pos + 2));
                            String test = tok.nextToken();
                            if ("exit".equals(test)) {
                                return;
                            }
                            if ("localvar".equals(test)) {
                                String varName = tok.nextToken();
                                namePos = lines[i].indexOf(varName);
                                Assert.isLegal((namePos >= 0 ? 1 : 0) != 0);
                                arrow = tok.nextToken();
                                Assert.isLegal((boolean)arrow.equals("=>"));
                                correctClassRef = tok.nextToken();
                                this.assertions.add(new VariableReturnTypeAssertion(varName, namePos += lineOffset, correctClassRef));
                            } else if ("expr".equals(test)) {
                                String expr = tok.nextToken();
                                namePos = lines[i].indexOf(expr);
                                Assert.isLegal((namePos >= 0 ? 1 : 0) != 0);
                                arrow = tok.nextToken();
                                Assert.isLegal((boolean)arrow.equals("=>"));
                                correctClassRef = tok.nextToken();
                                this.assertions.add(new ExpressionTypeAssertion(expr, namePos += lineOffset, correctClassRef));
                            }
                        }
                        lineOffset += lines[i].length() + 1;
                        ++i;
                    }
                    DLTKTypeInferenceEngine inferencer = new DLTKTypeInferenceEngine();
                    TypeInferenceTest tests = new TypeInferenceTest("ruby selection tests");
                    tests.setUpSuite();
                    try {
                        tests.executeTest(folder, name, (ITypeInferencer)inferencer, this.assertions);
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        tests.tearDownSuite();
                        throw throwable;
                    }
                    {
                        Object var6_9 = null;
                    }
                    tests.tearDownSuite();
                }

                class ExpressionTypeAssertion
                implements IAssertion {
                    private final String correctClassRef;
                    private final int namePos;

                    public ExpressionTypeAssertion(String expression, int namePos, String correctClassRef) {
                        this.namePos = namePos;
                        this.correctClassRef = correctClassRef;
                    }

                    public void check(ModuleDeclaration rootNode, ISourceModule cu, ITypeInferencer inferencer) throws Exception {
                        ASTNode[] result = new ASTNode[1];
                        OffsetTargetedASTVisitor visitor = new OffsetTargetedASTVisitor(this, this.namePos, result){
                            final /* synthetic */ ExpressionTypeAssertion this$2;
                            private final /* synthetic */ ASTNode[] val$result;
                            {
                                this.this$2 = expressionTypeAssertion;
                                this.val$result = aSTNodeArray;
                            }

                            protected boolean visitGeneralInteresting(ASTNode s) {
                                if (s instanceof ASTNode && this.val$result[0] == null && s.sourceStart() == ExpressionTypeAssertion.access$0(this.this$2)) {
                                    this.val$result[0] = s;
                                }
                                return true;
                            }
                        };
                        rootNode.traverse((ASTVisitor)visitor);
                        if (result[0] == null) {
                            System.out.println("ExpressionTypeAssertion.check()");
                        }
                        Assert.isLegal((result[0] != null ? 1 : 0) != 0);
                        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(cu, rootNode), result[0]);
                        IEvaluatedType type = inferencer.evaluateType((AbstractTypeGoal)goal, -1);
                        if (!this.correctClassRef.equals("recursion")) {
                            if (type == null) {
                                throw new AssertionFailedError("null type fetched, but " + this.correctClassRef + " expected");
                            }
                            1.assertNotNull((Object)type);
                            if (type instanceof SimpleType) {
                                IEvaluatedType intrinsicType = TypeInferenceSuite.getIntrinsicType(this.correctClassRef);
                                1.assertEquals((Object)intrinsicType, (Object)type);
                            } else if (type instanceof RubyClassType) {
                                RubyClassType rubyType = (RubyClassType)type;
                                1.assertEquals((String)this.correctClassRef, (String)rubyType.getModelKey());
                            } else if (type instanceof AmbiguousType) {
                                AmbiguousType ambiType = (AmbiguousType)type;
                                HashSet<String> modelKeySet = new HashSet<String>();
                                IEvaluatedType[] possibleTypes = ambiType.getPossibleTypes();
                                int cnt = 0;
                                int max = possibleTypes.length;
                                while (cnt < max) {
                                    if (possibleTypes[cnt] instanceof RubyClassType) {
                                        modelKeySet.add(((RubyClassType)possibleTypes[cnt]).getModelKey());
                                    }
                                    ++cnt;
                                }
                                1.assertTrue((boolean)modelKeySet.contains(this.correctClassRef));
                            } else {
                                1.fail((String)("Unrecognized IEvaluatedType was inferred: " + type.getClass().getName()));
                            }
                        }
                    }

                    static /* synthetic */ int access$0(ExpressionTypeAssertion expressionTypeAssertion) {
                        return expressionTypeAssertion.namePos;
                    }
                }

                class VariableReturnTypeAssertion
                implements IAssertion {
                    private final String correctClassRef;
                    private final int namePos;

                    public VariableReturnTypeAssertion(String varName, int namePos, String correctClassRef) {
                        this.namePos = namePos;
                        this.correctClassRef = correctClassRef;
                    }

                    public void check(ModuleDeclaration rootNode, ISourceModule cu, ITypeInferencer inferencer) throws Exception {
                        ASTNode[] result = new ASTNode[1];
                        OffsetTargetedASTVisitor visitor = new OffsetTargetedASTVisitor(this, this.namePos, result){
                            final /* synthetic */ VariableReturnTypeAssertion this$2;
                            private final /* synthetic */ ASTNode[] val$result;
                            {
                                this.this$2 = variableReturnTypeAssertion;
                                this.val$result = aSTNodeArray;
                            }

                            protected boolean visitGeneralInteresting(ASTNode s) {
                                if (s instanceof VariableReference && s.sourceStart() == VariableReturnTypeAssertion.access$0(this.this$2) && this.val$result[0] == null) {
                                    this.val$result[0] = s;
                                }
                                return true;
                            }
                        };
                        rootNode.traverse((ASTVisitor)visitor);
                        Assert.isLegal((result[0] != null ? 1 : 0) != 0);
                        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(cu, rootNode), result[0]);
                        IEvaluatedType type = inferencer.evaluateType((AbstractTypeGoal)goal, -1);
                        1.assertNotNull((Object)type);
                        1.assertEquals((String)this.correctClassRef, (String)((RubyClassType)type).getModelKey());
                    }

                    static /* synthetic */ int access$0(VariableReturnTypeAssertion variableReturnTypeAssertion) {
                        return variableReturnTypeAssertion.namePos;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadContent(String path) throws IOException {
        StringBuffer buffer = new StringBuffer();
        InputStream input = null;
        try {
            input = Activator.openResource(path);
            InputStreamReader reader = new InputStreamReader(input);
            BufferedReader br = new BufferedReader(reader);
            char[] data = new char[102400];
            int size = br.read(data);
            buffer.append(data, 0, size);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (input == null) throw throwable;
            input.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
            if (input == null) return buffer.toString();
        }
        input.close();
        return buffer.toString();
    }

    private static IEvaluatedType getIntrinsicType(String correctClassRef) {
        Object correctType = "recursion".equals(correctClassRef) ? RecursionTypeCall.INSTANCE : ("any".equals(correctClassRef) ? UnknownType.INSTANCE : null);
        return correctType;
    }
}

