/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.typeinference;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ruby.core.tests.typeinference.AbstractTypeInferencingTests;
import org.eclipse.dltk.ruby.core.tests.typeinference.IAssertion;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.ITypeInferencer;

public class TypeInferenceTest
extends AbstractTypeInferencingTests {
    private static final String SRC_PROJECT = "typeinference";

    public TypeInferenceTest(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        PROJECT = this.setUpScriptProject(SRC_PROJECT);
        super.setUpSuite();
        TypeInferenceTest.waitUntilIndexesReady();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(SRC_PROJECT);
        super.tearDownSuite();
    }

    public void executeTest(String folder, String name, ITypeInferencer inferencer, Collection assertions) throws Exception {
        TypeInferenceTest.waitForAutoBuild();
        ISourceModule cu = this.getSourceModule(SRC_PROJECT, folder, name);
        ModuleDeclaration rootNode = RubyTypeInferencingUtils.parseSource((ISourceModule)cu);
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            IAssertion assertion = (IAssertion)iter.next();
            assertion.check(rootNode, cu, inferencer);
        }
    }
}

