/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.tests.typeinference.utils;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ruby.core.tests.typeinference.AbstractTypeInferencingTests;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.LocalVariableInfo;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;

public class LocalVariablesInspectionTest
extends AbstractTypeInferencingTests {
    private static final String PATH_PREFIX = "/workspace/typeinference2/localvars/";
    private static final String SRC_PROJECT = "typeinference2";

    public LocalVariablesInspectionTest(String name) {
        super("org.eclipse.dltk.ruby.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        PROJECT = this.setUpScriptProject(SRC_PROJECT);
        super.setUpSuite();
        LocalVariablesInspectionTest.waitUntilIndexesReady();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(SRC_PROJECT);
        super.tearDownSuite();
    }

    public void testGlobalExistant() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/simple1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalExistant2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/simple1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts y") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"y");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalNotExistant() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/simple1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"y");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalConditional1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/conditional1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalConditional2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/conditional2.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalConditional3() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/conditional3.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testGlobalConditional4() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/conditional4.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("bye") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }

    public void testInsideMethod1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
    }

    public void testInsideMethod1_2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("y = 53") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
    }

    public void testInsideMethod1_3() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts \"") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof ModuleDeclaration));
    }

    public void testInsideMethod1_4() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("bye") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"y");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
    }

    public void testInsideType1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/class1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts x") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof TypeDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }

    public void testInsideType1_2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/class1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("yyyy") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testInsideType1_3() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/class1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("bye") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof TypeDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testInsideType1_4() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/class1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("putx") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof TypeDeclaration));
        LocalVariablesInspectionTest.assertEquals((String)"Cool", (String)((TypeDeclaration)info.getDeclaringScope()).getName());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testInsideMethod2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method2.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("haha") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }

    public void testInsideMethod2_1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method2.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts x") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testInsideMethod2_2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/method2.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("gigi") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"x");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }

    public void testLoops1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/loop1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("puts var") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof TypeDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testLoops1_2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/loop1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("for") - 2;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)2, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testLoops1_3() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/loop1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("putX var") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)3, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testLoops1_4() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/loop1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("putxxx") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)3, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testBlocks1() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/blocks1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("label1") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testBlocks1_2() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/blocks1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("label2") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNotNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getConditionalAssignments().length);
    }

    public void testBlocks1_3() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/blocks1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("label3") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof MethodDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }

    public void testBlocks1_4() throws Exception {
        String content = this.loadContent("/workspace/typeinference2/localvars/blocks1.rb");
        ModuleDeclaration ast = ASTUtils.getAST((char[])content.toCharArray());
        int offset = content.indexOf("label4") + 1;
        LocalVariableInfo info = RubyTypeInferencingUtils.inspectLocalVariable((ModuleDeclaration)ast, (int)offset, (String)"var");
        LocalVariablesInspectionTest.assertTrue((boolean)(info.getDeclaringScope() instanceof TypeDeclaration));
        LocalVariablesInspectionTest.assertEquals((int)0, (int)info.getKind());
        LocalVariablesInspectionTest.assertNull((Object)info.getLastAssignment());
        LocalVariablesInspectionTest.assertEquals((int)1, (int)info.getConditionalAssignments().length);
    }
}

