/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.buildpath;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Test;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.utils.CorePrinter;

public class BuildpathTests
extends ModifyingResourceTests {
    private static final String[] TEST_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    static /* synthetic */ Class class$0;

    public BuildpathTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.buildpath.BuildpathTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    private void assertEncodeDecodeEntry(String projectName, String expectedEncoded, IBuildpathEntry entry) {
        IScriptProject project = this.getScriptProject(projectName);
        String encoded = project.encodeBuildpathEntry(entry);
        this.assertSourceEquals("Unexpected encoded entry", expectedEncoded, encoded);
        IBuildpathEntry decoded = project.decodeBuildpathEntry(encoded);
        BuildpathTests.assertEquals((String)"Unexpected decoded entry", (Object)entry, (Object)decoded);
    }

    protected void assertStatus(String expected, IStatus status) {
        String actual = status.getMessage();
        expected.equals(actual);
        BuildpathTests.assertEquals((String)expected, (String)actual);
    }

    protected void assertStatus(String message, String expected, IStatus status) {
        String actual = status.getMessage();
        expected.equals(actual);
        BuildpathTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected File createFile(File parent, String name, String content) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        file.setLastModified(System.currentTimeMillis() + 2000L);
        return file;
    }

    protected File createFolder(File parent, String name) {
        File file = new File(parent, name);
        file.mkdirs();
        return file;
    }

    protected int numberOfCycleMarkers(IScriptProject scriptProject) throws CoreException {
        IMarker[] markers = scriptProject.getProject().findMarkers("org.eclipse.dltk.core.buildpath_problem", false, 0);
        int result = 0;
        int i = 0;
        int length = markers.length;
        while (i < length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test005() throws Exception {
        try {
            String filePath = "/usr/lib/python2.4/";
            IScriptProject proj = this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            IBuildpathEntry[] originalCP = proj.getRawBuildpath();
            IBuildpathEntry[] newCP = new IBuildpathEntry[originalCP.length + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
            newCP[originalCP.length] = DLTKCore.newExtLibraryEntry((IPath)EnvironmentPathUtils.getFullPath((IEnvironment)EnvironmentManager.getEnvironment((IModelElement)proj), (IPath)new Path(filePath)));
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)proj, (IBuildpathEntry[])newCP);
            this.assertStatus("OK", (IStatus)status);
            proj.setRawBuildpath(newCP, null);
            CorePrinter printer = new CorePrinter((OutputStream)System.out, true);
            printer.flush();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P");
    }
}

