/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.core.tests.util.ModelTestUtils;
import org.eclipse.dltk.python.internal.core.parser.PythonSourceParser;
import org.eclipse.dltk.python.parser.ast.PythonWithStatement;

public class ComplexConstructsTests
extends AbstractModelTests {
    private static final String PROJECT_NAME = "pytests_proj";
    private static final String ASSIGNMENT_TESTS_FILE_NAME = "assignment_tests.py";
    private static final String SCRIPT_SOURCE = "a,b=1,2;c=d=1;x=y=lambda z:z;";
    static /* synthetic */ Class class$0;

    public ComplexConstructsTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.ComplexConstructsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IScriptProject sp = this.setUpScriptProject(PROJECT_NAME);
        IProject prj = sp.getProject();
        IFile testFile = prj.getFile(ASSIGNMENT_TESTS_FILE_NAME);
        ByteArrayInputStream source = new ByteArrayInputStream(SCRIPT_SOURCE.getBytes());
        testFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.deleteProject(PROJECT_NAME);
    }

    public void testAssignment() throws Exception {
        IScriptProject project = this.getScriptProject(PROJECT_NAME);
        ISourceModule module = this.getSourceModule(PROJECT_NAME, project.getPath().toString(), ASSIGNMENT_TESTS_FILE_NAME);
        IModelElement[] children = module.getChildren();
        ModelTestUtils.getAssertField((IModelElement[])children, (String)"a");
        ModelTestUtils.getAssertField((IModelElement[])children, (String)"b");
        ModelTestUtils.getAssertField((IModelElement[])children, (String)"c");
        ModelTestUtils.getAssertField((IModelElement[])children, (String)"d");
        ModelTestUtils.getAssertMethod((IModelElement[])children, (String)"x", (int)1);
        ModelTestUtils.getAssertMethod((IModelElement[])children, (String)"y", (int)1);
    }

    public void testWithStatement() {
        PythonSourceParser parser = new PythonSourceParser();
        ModuleDeclaration module = parser.parse(null, "with a as b : pass".toCharArray(), null);
        List children = ((Block)module.getChilds().get(0)).getChilds();
        Object pws = children.get(0);
        ComplexConstructsTests.assertTrue((String)"with...as... statement expected.", (boolean)(pws instanceof PythonWithStatement));
        children = ((PythonWithStatement)pws).getChilds();
        ComplexConstructsTests.assertTrue((String)"Three children expected", (3 == children.size() ? 1 : 0) != 0);
        ComplexConstructsTests.assertTrue((String)"Expression expected.", (boolean)(children.get(0) instanceof Expression));
        ComplexConstructsTests.assertTrue((String)"Expression expected.", (boolean)(children.get(1) instanceof Expression));
        ComplexConstructsTests.assertTrue((String)"Block expected.", (boolean)(children.get(2) instanceof Block));
    }
}

