/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class ExclusionPatternsTests
extends ModifyingResourceTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    IScriptProject project;
    static /* synthetic */ Class class$0;

    public ExclusionPatternsTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    protected void setBuildpath(String[] sourceFoldersAndExclusionPatterns) throws ModelException {
        this.project.setRawBuildpath(this.createBuildpath(sourceFoldersAndExclusionPatterns, false, true), null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createScriptProject("P", PYTHON_NATURE, new String[]{"src", "bin"});
        this.project.setRawBuildpath(this.createBuildpath(new String[]{"/P/bin"}), null);
        this.startDeltas();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.ExclusionPatternsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    protected void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void testAddExclusionOnSourceModule() throws CoreException {
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | BUILDPATH CHANGED}\n\tsrc[*]: {ADDED TO BUILDPATH | REMOVED FROM BUILDPATH}\n\tResourceDelta(/P/.buildpath)[*]");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.py", pkg.getForeignResources());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExclusionOnFolderUnderProject() throws CoreException {
        try {
            IScriptProject scriptProject = this.createScriptProject("P1", PYTHON_NATURE, new String[]{""});
            this.createFolder("/P1/doc");
            this.clearDeltas();
            scriptProject.setRawBuildpath(this.createBuildpath(new String[]{"/P1", "doc/"}, false, true), null);
            this.assertDeltas("Unexpected deltas", "P1[*]: {CHILDREN | BUILDPATH CHANGED}\n\t<project root>[*]: {ADDED TO BUILDPATH | REMOVED FROM BUILDPATH}\n\tResourceDelta(/P1/.buildpath)[*]");
            IProjectFragment root = this.getProjectFragment("/P1");
            this.assertSortedElementsEqual("Unexpected children", "<default> [in <project root> [in P1]]", root.getChildren());
            this.assertResourceNamesEqual("Unexpected non-java resources of project", ".buildpath\n.project\ndoc", scriptProject.getForeignResources());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    public void testAddExclusionOnPackage() throws CoreException {
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setBuildpath(new String[]{"/P/src", "p/"});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | BUILDPATH CHANGED}\n\tsrc[*]: {ADDED TO BUILDPATH | REMOVED FROM BUILDPATH}\n\tResourceDelta(/P/.buildpath)[*]");
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getForeignResources());
    }

    /*
     * Exception decompiling
     */
    public void testAddExclusionOnPrimaryWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 122->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testAddToExcludedFolder() throws CoreException {
        this.createFolder("/P/src/icons");
        this.setBuildpath(new String[]{"/P/src", "icons/"});
        this.clearDeltas();
        this.createFile("/P/src/icons/my.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/icons)[*]");
        this.clearDeltas();
        this.deleteFile("/P/src/icons/my.txt");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/icons)[*]");
    }

    public void testCreateExcludedSourceModule() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.createFolder("/P/src/p");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.clearDeltas();
        pkg.createSourceModule("A.py", "package p;\npublic class A {\n}", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/A.py)[+]");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.py", pkg.getForeignResources());
    }

    public void testCreateExcludedPackage() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p/"});
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.clearDeltas();
        root.createScriptFolder("p", false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/p)[+]");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getForeignResources());
    }

    public void testCreateExcludedPackage2() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "org/*|org/eclipse/*"});
        this.clearDeltas();
        this.createFolder("/P/src/org/eclipse/mypack");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/org)[+]");
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\norg.eclipse.mypack [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "org", root.getForeignResources());
    }

    public void testCreateExcludedAndIncludedPackages() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p1/p2/"});
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.clearDeltas();
        this.createFolder("/P/src/p1/p2");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp1[+]: {}");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\np1 [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p2", root.getScriptFolder("p1").getForeignResources());
    }

    public void testCreateResourceExcludedSourceModule() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CONTENT}\n\t\t\tResourceDelta(/P/src/p/A.py)[+]");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "A.py", pkg.getForeignResources());
    }

    public void testCreateResourceExcludedPackage() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p/"});
        this.clearDeltas();
        this.createFolder("/P/src/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/p)[+]");
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "p", root.getForeignResources());
    }

    public void testIsOnClasspath1() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", ""});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        ExclusionPatternsTests.assertTrue((String)"Resource should be on buildpath", (boolean)this.project.isOnBuildpath((IResource)file));
        ISourceModule cu = this.getSourceModule("/P/src/p/A.py");
        ExclusionPatternsTests.assertTrue((String)"CU should be on buildpath", (boolean)this.project.isOnBuildpath((IModelElement)cu));
    }

    public void testIsOnClasspath2() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        ExclusionPatternsTests.assertTrue((String)"Resource should not be on buildpath", (!this.project.isOnBuildpath((IResource)file) ? 1 : 0) != 0);
        ISourceModule cu = this.getSourceModule("/P/src/p/A.py");
        ExclusionPatternsTests.assertTrue((String)"CU should not be on buildpath", (!this.project.isOnBuildpath((IModelElement)cu) ? 1 : 0) != 0);
    }

    public void testIsOnClasspath3() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", ""});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        ExclusionPatternsTests.assertTrue((String)"Resource should be on buildpath", (boolean)this.project.isOnBuildpath((IResource)file));
    }

    public void testIsOnClasspath4() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p/**"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/readme.txt", "");
        ExclusionPatternsTests.assertTrue((String)"Resource should not be on buildpath", (!this.project.isOnBuildpath((IResource)file) ? 1 : 0) != 0);
    }

    public void testNestedSourceFolder1() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        IProjectFragment root1 = this.getProjectFragment("/P/src1");
        this.assertResourceNamesEqual("Unexpected non-java resources for /P/src1", "", root1.getForeignResources());
    }

    public void testNestedSourceFolder2() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/A.py", "public class A {\n}");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tA.py[+]: {}");
    }

    public void testNestedSourceFolder3() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFile("/P/src1/src2/readme.txt", "");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CONTENT}\n\t\tResourceDelta(/P/src1/src2/readme.txt)[+]");
    }

    public void testNestedSourceFolder4() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder5() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.clearDeltas();
        this.createFolder("/P/src1/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[+]: {}");
    }

    public void testNestedSourceFolder6() throws CoreException {
        this.setBuildpath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""});
        this.createFolder("/P/src1/src2");
        this.createFolder("/P/src1/p");
        this.clearDeltas();
        this.moveFolder("/P/src1/p", "/P/src1/src2/p");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc1[*]: {CHILDREN}\n\t\tp[-]: {MOVED_TO(p [in src1/src2 [in P]])}\n\tsrc1/src2[*]: {CHILDREN}\n\t\tp[+]: {MOVED_FROM(p [in src1 [in P]])}");
    }

    public void testRenameExcludedSourceModule() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.py"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tB.py[+]: {}\n\t\t\tResourceDelta(/P/src/p/A.py)[-]");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "B.py [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getForeignResources());
    }

    public void testRenameExcludedPackage() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p/"});
        IProjectFragment root = this.getProjectFragment("/P/src");
        IScriptFolder pkg = root.createScriptFolder("p", false, null);
        this.clearDeltas();
        pkg.getResource().move((IPath)new Path("/P/src/q"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tq[+]: {}\n\t\tResourceDelta(/P/src/p)[-]");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\nq [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getForeignResources());
    }

    public void testRenameResourceExcludedSourceModule() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "**/A.py"});
        this.createFolder("/P/src/p");
        IFile file = this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        this.clearDeltas();
        file.move((IPath)new Path("/P/src/p/B.py"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN | CONTENT}\n\t\t\tB.py[+]: {}\n\t\t\tResourceDelta(/P/src/p/A.py)[-]");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "B.py [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getForeignResources());
    }

    public void testRemoveExcludedAndIncludedPackages() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p1/p2/"});
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.createFolder("/P/src/p1/p2");
        this.clearDeltas();
        this.deleteFolder("/P/src/p1");
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp1[-]: {}");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getForeignResources());
    }

    public void testRenameResourceExcludedPackage() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p/"});
        IFolder folder = this.createFolder("/P/src/p");
        this.clearDeltas();
        folder.move((IPath)new Path("/P/src/q"), false, null);
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN | CONTENT}\n\t\tq[+]: {}\n\t\tResourceDelta(/P/src/p)[-]");
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\nq [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getForeignResources());
    }

    public void testRemoveExclusionOnSourceModule() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "A.py"});
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/A.py", "package p;\npublic class A {\n}");
        this.clearDeltas();
        this.setBuildpath(new String[]{"/P/src", ""});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | BUILDPATH CHANGED}\n\tsrc[*]: {ADDED TO BUILDPATH | REMOVED FROM BUILDPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IScriptFolder pkg = this.getPackage("/P/src/p");
        this.assertSortedElementsEqual("Unexpected children", "A.py [in p [in src [in P]]]", pkg.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", pkg.getForeignResources());
    }

    public void testRemoveExclusionOnPackage() throws CoreException {
        this.setBuildpath(new String[]{"/P/src", "p"});
        this.createFolder("/P/src/p");
        this.clearDeltas();
        this.setBuildpath(new String[]{"/P/src", ""});
        this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | BUILDPATH CHANGED}\n\tsrc[*]: {ADDED TO BUILDPATH | REMOVED FROM BUILDPATH}\n\tResourceDelta(/P/.classpath)[*]");
        IProjectFragment root = this.getProjectFragment("/P/src");
        this.assertSortedElementsEqual("Unexpected children", "<default> [in src [in P]]\np [in src [in P]]", root.getChildren());
        this.assertResourceNamesEqual("Unexpected non-java resources", "", root.getForeignResources());
    }
}

