/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.core.tests.model.TestBuffer;

public class WorkingCopyTests
extends ModifyingResourceTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    ISourceModule cu = null;
    ISourceModule copy = null;
    static /* synthetic */ Class class$0;

    public WorkingCopyTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.createScriptProject("P", PYTHON_NATURE, new String[]{"src"});
            this.createFolder("P/src/x/y");
            this.createFile("P/src/x/y/A.py", "import os;\nclass A:\n    class Inner:\n        def __init__():pass\n        innerField = 10;\n        def innerMethod():pass\n    FIELD=\"\";\n    field1=1;\n    field2=false;\n    def foo():pass\n\n");
            this.cu = this.getSourceModule("P/src/x/y/A.py");
            this.copy = this.cu.getWorkingCopy(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        if (this.copy != null) {
            this.copy.discardWorkingCopy();
        }
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCancelMakeConsistent() throws ModelException {
        String newContents = "class A:\n\tdef bar():\n\t\tpass\n";
        this.copy.getBuffer().setContents(newContents);
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        try {
            this.copy.makeConsistent((IProgressMonitor)monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        WorkingCopyTests.assertTrue((String)"Working copy should be opened", (boolean)this.copy.isOpen());
    }

    public void testChangeContent() throws CoreException {
        String newContents = "class A:\n\tdef bar():\n\t\tpass\n";
        this.copy.getBuffer().setContents(newContents);
        this.copy.reconcile(false, null, null);
        this.assertSourceEquals("Unexpected working copy contents", newContents, this.copy.getBuffer().getContents());
        this.copy.commitWorkingCopy(true, null);
        this.assertSourceEquals("Unexpected original cu contents", newContents, this.cu.getBuffer().getContents());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeContentOfReadOnlyCU1() throws CoreException {
        IResource resource = this.cu.getUnderlyingResource();
        boolean readOnlyFlag = this.isReadOnly(resource);
        boolean didComplain = false;
        try {
            try {
                this.setReadOnly(resource, true);
                this.copy.getBuffer().setContents("invalid");
                this.copy.commitWorkingCopy(true, null);
            }
            catch (ModelException modelException) {
                didComplain = true;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setReadOnly(resource, readOnlyFlag);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.setReadOnly(resource, readOnlyFlag);
        WorkingCopyTests.assertTrue((String)"Should have complained about modifying a read-only unit:", (boolean)didComplain);
        WorkingCopyTests.assertTrue((String)"ReadOnly buffer got modified:", (!this.cu.getBuffer().getContents().equals("invalid") ? 1 : 0) != 0);
    }

    public void testGetPrimaryCU() {
        IModelElement primary = this.copy.getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a cu", (primary instanceof ISourceModule && !((ISourceModule)primary).isWorkingCopy() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void REM_testGetPrimaryField() {
        IType type = this.copy.getType("A");
        IModelElement primary = type.getField("FIELD").getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a field", (primary instanceof IField && !((ISourceModule)primary.getParent().getParent()).isWorkingCopy() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void testGetPrimaryInnerField() {
        IType innerType = this.copy.getType("A").getType("Inner");
        IModelElement primary = innerType.getField("innerField").getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a field", (boolean)(primary instanceof IField));
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void testGetPrimaryInnerMethod() throws ModelException {
        IType innerType = this.copy.getType("A").getType("Inner");
        IModelElement primary = innerType.getMethods()[0].getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a method", (boolean)(primary instanceof IMethod));
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public class TestWorkingCopyOwner
    extends WorkingCopyOwner {
        public IBuffer createBuffer(ISourceModule workingCopy) {
            return new TestBuffer((IOpenable)workingCopy);
        }
    }
}

