/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.testing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.tcl.internal.debug.ui.launchConfigurations.TclMainLaunchConfigurationTab;
import org.eclipse.dltk.tcl.internal.testing.TclTestingEngineManager;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TclTestingMainLaunchConfigurationTab
extends TclMainLaunchConfigurationTab {
    private Button detect;
    private Combo engineType;
    private Map nameToId = new HashMap();

    public TclTestingMainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    protected void doCreateControl(Composite composite) {
        this.createMainModuleEditor(composite, DLTKLaunchConfigurationsMessages.mainTab_mainModule);
        this.createVerticalSpacer(composite, 1);
        this.createTestEngineEditor(composite, "Tcl Testing engine");
    }

    protected void createTestEngineEditor(Composite parent, String text) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(text);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.engineType = new Combo((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.engineType.setLayoutData((Object)gd);
        this.engineType.setFont(font);
        this.engineType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TclTestingMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.detect = this.createPushButton((Composite)mainGroup, "Detect", null);
        ITclTestingEngine[] engines = TclTestingEngineManager.getEngines();
        int i = 0;
        while (i < engines.length) {
            String name = engines[i].getName();
            this.engineType.add(name);
            this.nameToId.put(name, engines[i].getId());
            ++i;
        }
        this.detect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclTestingMainLaunchConfigurationTab.this.handleDetectButtonSelected();
            }
        });
        this.handleDetectButtonSelected();
    }

    private void handleDetectButtonSelected() {
        ITclTestingEngine[] engines = TclTestingEngineManager.getEngines();
        ISourceModule module = this.getSourceModule();
        if (module != null && module.exists()) {
            int i = 0;
            while (i < engines.length) {
                if (engines[i].isValidModule(module)) {
                    this.engineType.select(i);
                }
                ++i;
            }
        }
    }

    private ISourceModule getSourceModule() {
        IScriptProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IProject prj = project.getProject();
        String scriptName = this.getScriptName();
        ISourceModule module = null;
        IFile res = prj.getFile(scriptName);
        module = (ISourceModule)DLTKCore.create((IResource)res);
        return module;
    }

    protected boolean doCanSave() {
        return this.validateScript() && this.validateEngine();
    }

    private boolean validateEngine() {
        ISourceModule module = this.getSourceModule();
        if (module != null) {
            ITclTestingEngine[] engines = TclTestingEngineManager.getEngines();
            int i = 0;
            while (i < engines.length) {
                String selectedEngine = this.getEngineId();
                if (engines[i].getId().equals(selectedEngine) && engines[i].isValidModule(module)) {
                    return true;
                }
                ++i;
            }
        }
        this.setErrorMessage("Testing engine not support specified script");
        return true;
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        super.doPerformApply(config);
        config.setAttribute("org.eclipse.dltk.testing.engineId", this.getEngineId());
    }

    private String getEngineId() {
        return (String)this.nameToId.get(this.engineType.getText());
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        String id;
        ITclTestingEngine[] engines;
        block6: {
            super.doInitializeForm(config);
            engines = TclTestingEngineManager.getEngines();
            id = null;
            try {
                id = config.getAttribute("org.eclipse.dltk.testing.engineId", "");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (id == null || id.length() == 0) {
            this.handleDetectButtonSelected();
        } else {
            int i = 0;
            while (i < engines.length) {
                if (engines[i].getId().equals(id)) {
                    this.engineType.select(i);
                }
                ++i;
            }
        }
    }
}

