/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.tests.SimpleValidator;
import org.eclipse.dltk.validators.core.tests.SimpleValidatorType;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.validators.internal.core.ValidatorManager;

public class ValidatorContainerTests
extends TestCase {
    public void testValidatorContainer001() throws Exception {
        ValidatorDefinitionsContainer co = new ValidatorDefinitionsContainer();
        ValidatorContainerTests.assertNotNull((Object)co);
        SimpleValidatorType vt = this.findSimpleValidtor();
        ValidatorContainerTests.assertNotNull((Object)((Object)vt));
        ValidatorContainerTests.assertTrue((boolean)vt.isConfigurable());
        IValidator v1 = vt.createValidator("v1");
        ValidatorContainerTests.assertNotNull((Object)v1);
        co.addValidator(v1);
        IValidator v2 = vt.createValidator("v2");
        ((SimpleValidator)v2).setValid(false);
        ValidatorContainerTests.assertNotNull((Object)v2);
        co.addValidator(v2);
        String xml = co.getAsXML();
        ValidatorContainerTests.assertNotNull((Object)xml);
        System.out.println(xml);
        List validValidatorsList = co.getValidatorsList();
        List validatorList = co.getValidatorList();
        ValidatorContainerTests.assertNotNull((Object)validValidatorsList);
        ValidatorContainerTests.assertNotNull((Object)validatorList);
        ValidatorContainerTests.assertTrue((boolean)validValidatorsList.contains(v1));
        ValidatorContainerTests.assertTrue((boolean)validValidatorsList.contains(v2));
        ValidatorContainerTests.assertTrue((boolean)validatorList.contains(v1));
        ValidatorContainerTests.assertTrue((boolean)validatorList.contains(v2));
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        ValidatorDefinitionsContainer co2 = ValidatorDefinitionsContainer.parseXMLIntoContainer((InputStream)bais);
        ValidatorContainerTests.assertNotNull((Object)co2);
        List validatorList2 = co2.getValidatorList();
        ValidatorContainerTests.assertNotNull((Object)validatorList2);
        ValidatorContainerTests.assertEquals((int)2, (int)validatorList.size());
        List validatorList3 = co2.getValidatorList("#");
        ValidatorContainerTests.assertNotNull((Object)validatorList3);
        ValidatorContainerTests.assertEquals((int)2, (int)validatorList.size());
        int i = 0;
        while (i < validatorList2.size()) {
            IValidator v = (IValidator)validatorList2.get(i);
            ValidatorContainerTests.assertNotNull((Object)v);
            ValidatorContainerTests.assertTrue((v.getID().equals("v1") || v.getID().equals("v2") ? 1 : 0) != 0);
            if (v.getID().equals("v1")) {
                ValidatorContainerTests.assertTrue((boolean)((SimpleValidator)v).valid);
            }
            if (v.getID().equals("v2")) {
                ValidatorContainerTests.assertFalse((boolean)((SimpleValidator)v).valid);
            }
            ++i;
        }
    }

    private SimpleValidatorType findSimpleValidtor() throws CoreException {
        IValidatorType[] allValidatorTypes = ValidatorManager.getAllValidatorTypes();
        int i = 0;
        while (i < allValidatorTypes.length) {
            if (allValidatorTypes[i] instanceof SimpleValidatorType) {
                return (SimpleValidatorType)allValidatorTypes[i];
            }
            ++i;
        }
        return null;
    }
}

