/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.ui.tests.indenting;

import org.eclipse.dltk.python.internal.ui.text.PythonAutoEditStrategy;
import org.eclipse.dltk.python.internal.ui.text.PythonPartitionScanner;
import org.eclipse.dltk.python.ui.PythonPreferenceConstants;
import org.eclipse.dltk.python.ui.tests.PythonUITestsPlugin;
import org.eclipse.dltk.python.ui.tests.indenting.PyUITest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class SimpleIndentingTest
extends PyUITest {
    private IPreferenceStore fStore;

    private void installStuff(Document document) {
        String[] types = new String[]{"__python_string", "__python_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PythonPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__python_partitioning", (IDocumentPartitioner)partitioner);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fStore = PythonUITestsPlugin.getDefault().getPreferenceStore();
        PythonPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
    }

    public void REM_testParts() throws Exception {
        String text = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/test_crypt.py");
        Document temp = new Document(text);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        ITypedRegion region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)2, (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__python_comment", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)temp.getLineOffset(3), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__python_string", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(5) + 10), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__dftl_partition_content_type", (String)region.getType());
        region = TextUtilities.getPartition((IDocument)temp, (String)fPartitioning, (int)(temp.getLineOffset(8) + 19), (boolean)true);
        SimpleIndentingTest.assertEquals((String)"__python_string", (String)region.getType());
    }

    public void REM_testIndent00() throws Exception {
        String text = "class Foo:";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        int offset = temp.getLineOffset(0) + temp.getLineLength(0);
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "\n";
        strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        int newOffset = c.offset + (c.text == null ? 0 : c.text.length());
        if (c.caretOffset != -1) {
            newOffset = c.caretOffset;
        }
        temp.stopRewriteSession(session);
        String correct = "class Foo:\n\t";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
        SimpleIndentingTest.assertEquals((int)(offset + 1), (int)newOffset);
    }

    public void testIndent01_strings() throws Exception {
        String text = "print \"hello\"";
        Document temp = new Document(text);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        int offset = temp.getLineOffset(0) + temp.getLineLength(0);
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = "\n";
        strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        temp.stopRewriteSession(session);
        String correct = "print \"hello\"\n";
        String result = temp.get();
        SimpleIndentingTest.assertEquals((String)correct, (String)result);
    }

    public void REM_testIndent05_pasting() throws Exception {
        String text0 = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/my_test0_in.py");
        Document temp = new Document("");
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        int offset = 0;
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = text0;
        strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        temp.stopRewriteSession(session);
        SimpleIndentingTest.assertEquals((String)text0, (String)temp.get());
    }

    public void REM_testIndent06_pasting() throws Exception {
        String textIn = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/my_test1_in.py");
        String text0 = "a = 5\nb = 7\nif (smt):\n    go1\nelse:\n    go2\n    try:\n        wow\n    except:\n        nothing\n    else:\n        yes!\n";
        Document temp = new Document(textIn);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        int offset = temp.getLineOffset(12) + 8;
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = text0;
        strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        temp.stopRewriteSession(session);
        String textOut = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/my_test1_out.py");
        Document d2 = new Document(textOut);
        this.assertIndentingEquals((IDocument)d2, (IDocument)temp);
    }

    public void REM_testIndent07_pasting() throws Exception {
        String textIn = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/my_test1_in.py");
        String text0 = "a = 5\n            b = 7\n            if (smt):\n                go1\n            else:\n                go2\n                try:\n                    wow\n                except:\n                    nothing\n                else:\n                    yes!\n";
        Document temp = new Document(textIn);
        DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        this.installStuff(temp);
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        int offset = temp.getLineOffset(1) + 4;
        DocumentCommand c = new DocumentCommand(){};
        c.doit = true;
        c.caretOffset = -1;
        c.shiftsCaret = true;
        c.length = 0;
        c.offset = offset;
        c.text = text0;
        strategy.customizeDocumentCommand((IDocument)temp, c);
        temp.replace(c.offset, c.length, c.text);
        temp.stopRewriteSession(session);
        String textOut = PythonUITestsPlugin.getDefault().getPluginFileContent("/tests/my_test2_out.py");
        Document d2 = new Document(textOut);
        this.assertIndentingEquals((IDocument)d2, (IDocument)temp);
    }

    private void assertIndentingEquals(IDocument exp, IDocument act) {
        int line = 0;
        String fPartitioning = "__python_partitioning";
        PythonAutoEditStrategy strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
        try {
            int linesTotal = exp.getLineOfOffset(exp.getLength() - 1);
            SimpleIndentingTest.assertEquals((int)linesTotal, (int)act.getLineOfOffset(act.getLength() - 1));
            line = 0;
            while (line <= linesTotal) {
                String s1 = strategy.getDocumentLine(exp, line);
                String s2 = strategy.getDocumentLine(act, line);
                String ind1 = strategy.getLineIndent(s1);
                String ind2 = strategy.getLineIndent(s2);
                if (strategy.getPhysicalLength(ind1) != strategy.getPhysicalLength(ind2)) {
                    System.out.println("(line:" + line + ")\n" + s1 + "\nvs\n" + s2);
                }
                SimpleIndentingTest.assertEquals((int)strategy.getPhysicalLength(ind1), (int)strategy.getPhysicalLength(ind2));
                ++line;
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

