/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPageFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ManPageFolderXML {
    private static final String TOP_ELEMENT = "manPages";
    private static final String LOCATION_ELEMENT = "location";
    private static final String LOCATION_PATH_ATTRIBUTE = "path";
    private static final String PAGE_ELEMENT = "page";
    private static final String PAGE_FILE_ATTRIBUTE = "file";
    private static final String PAGE_KEYWORD_ATTRIBUTE = "keyword";

    public static String getDefault() {
        return "<manPages/>";
    }

    public static List read(String data) {
        if (data == null || data.length() == 0) {
            return new ArrayList();
        }
        Element config = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
        }
        catch (Exception e) {
            TclUI.error("Error parsing doc_man_pages_locations", e);
            return null;
        }
        if (!config.getNodeName().equalsIgnoreCase(TOP_ELEMENT)) {
            TclUI.error("doc_man_pages_locations - bad top level node");
            return null;
        }
        ArrayList<ManPageFolder> folders = new ArrayList<ManPageFolder>();
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase(LOCATION_ELEMENT)) {
                Element location = (Element)node;
                String path = location.getAttribute(LOCATION_PATH_ATTRIBUTE);
                ManPageFolder folder = new ManPageFolder(path);
                NodeList locationChilds = location.getChildNodes();
                int pages = locationChilds.getLength();
                int j = 0;
                while (j < pages) {
                    node = locationChilds.item(j);
                    type = node.getNodeType();
                    if (type == 1 && node.getNodeName().equalsIgnoreCase(PAGE_ELEMENT)) {
                        Element word = (Element)node;
                        String kw = word.getAttribute(PAGE_KEYWORD_ATTRIBUTE);
                        String file = word.getAttribute(PAGE_FILE_ATTRIBUTE);
                        folder.addPage(kw, file);
                    }
                    ++j;
                }
                folders.add(folder);
            }
            ++i;
        }
        return folders;
    }

    public static String write(List folders) {
        if (folders == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element topElement = doc.createElement(TOP_ELEMENT);
            doc.appendChild(topElement);
            Iterator i = folders.iterator();
            while (i.hasNext()) {
                ManPageFolder f = (ManPageFolder)i.next();
                Element location = doc.createElement(LOCATION_ELEMENT);
                topElement.appendChild(location);
                location.setAttribute(LOCATION_PATH_ATTRIBUTE, f.getPath());
                Iterator j = f.getPages().entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    String name = (String)entry.getKey();
                    String file = (String)entry.getValue();
                    Element page = doc.createElement(PAGE_ELEMENT);
                    location.appendChild(page);
                    page.setAttribute(PAGE_KEYWORD_ATTRIBUTE, name);
                    page.setAttribute(PAGE_FILE_ATTRIBUTE, file);
                }
            }
            StringWriter output = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
            return output.toString();
        }
        catch (Exception exception) {
            TclUI.error("Error serializing doc_man_pages_locations");
            return null;
        }
    }
}

