/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.tests.contentassist;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.NameLookup;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.javascript.internal.core.codeassist.completion.JavaScriptCompletionEngine;
import org.eclipse.dltk.utils.CorePrinter;

public class CodeCompletion
extends TestCase {
    public JavaScriptCompletionEngine createEngine(LinkedList results) {
        new NullEnvironment();
        JavaScriptCompletionEngine engine = new JavaScriptCompletionEngine();
        engine.setRequestor((CompletionRequestor)new TestCompletionRequetor(results));
        return engine;
    }

    private int lastPositionInFile(String string, String moduleName) {
        DataInputStream str;
        URL resource = ((Object)((Object)this)).getClass().getResource(moduleName);
        try {
            str = new DataInputStream(resource.openStream());
        }
        catch (IOException iOException) {
            return -1;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            while (str.available() >= 0) {
                int k = str.read();
                if (k != -1) {
                    bs.write(k);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        String content = "";
        try {
            content = new String(bs.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
        int position = content.lastIndexOf(string);
        if (position >= 0) {
            return position + string.length();
        }
        return -1;
    }

    private void compareNames(LinkedList results, String[] names) {
        CodeCompletion.assertEquals((int)results.size(), (int)names.length);
        Collections.sort(results, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                CompletionProposal pr = (CompletionProposal)arg0;
                CompletionProposal pr1 = (CompletionProposal)arg1;
                return new String(pr.getName()).compareTo(new String(pr1.getName()));
            }
        });
        Iterator it = results.iterator();
        int pos = 0;
        while (it.hasNext()) {
            CompletionProposal pr = (CompletionProposal)it.next();
            CodeCompletion.assertEquals((String)names[pos], (String)new String(pr.getName()));
            ++pos;
        }
    }

    private void basicTest(String mname, int position, String[] compNames) {
        LinkedList results = new LinkedList();
        JavaScriptCompletionEngine c = this.createEngine(results);
        c.setUseEngine(false);
        c.complete((ISourceModule)new TestModule(((Object)((Object)this)).getClass().getResource(mname)), position, 0);
        this.compareNames(results, compNames);
    }

    public void test0() {
        LinkedList results = new LinkedList();
        JavaScriptCompletionEngine c = this.createEngine(results);
        c.setUseEngine(false);
        c.complete((ISourceModule)new TestModule(""), 0, 0);
        CodeCompletion.assertEquals((int)0, (int)results.size());
    }

    public void test1() {
        LinkedList results = new LinkedList();
        JavaScriptCompletionEngine c = this.createEngine(results);
        c.setUseEngine(false);
        c.complete((ISourceModule)new TestModule(((Object)((Object)this)).getClass().getResource("test1.js")), 0, 0);
        CodeCompletion.assertEquals((int)0, (int)results.size());
    }

    public void test2() {
        String[] names = new String[]{"firstVar", "secondVar"};
        String module = "test2.js";
        int position = this.lastPositionInFile("\n", module);
        this.basicTest(module, position, names);
    }

    public void test3() {
        String[] names = new String[]{"world"};
        String module = "test3.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test4() {
        String[] names = new String[]{"temperature"};
        String module = "test4.js";
        int position = this.lastPositionInFile("firstVar.world.", module);
        this.basicTest(module, position, names);
    }

    public void test5() {
        String[] names = new String[]{"world"};
        String[] names1 = new String[]{"temperature"};
        String module = "test5.js";
        int positionFirst = this.lastPositionInFile("secondVar.", module);
        this.basicTest(module, positionFirst, names);
        int positionSecond = this.lastPositionInFile("world.", module);
        this.basicTest(module, positionSecond, names1);
    }

    public void test6() {
        String[] names = new String[]{"world"};
        String module = "test6.js";
        int position = this.lastPositionInFile("world.", module);
        this.basicTest(module, position, names);
    }

    public void test7() {
        String[] names = new String[]{"world"};
        String module = "test7.js";
        int position = this.lastPositionInFile("world.", module);
        this.basicTest(module, position, names);
    }

    public void test8() {
        String[] names = new String[]{"mission", "target"};
        String module = "test8.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test9() {
        String[] names = new String[]{};
        String module = "test9.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test10() {
        String[] names = new String[]{"mission", "target"};
        String module = "test10.js";
        int position = this.lastPositionInFile("secondVar.", module);
        this.basicTest(module, position, names);
    }

    public void test11() {
        String[] names = new String[]{"firstVar", "secondVar"};
        String module = "test11.js";
        int position = this.lastPositionInFile("{", module);
        this.basicTest(module, position, names);
    }

    public void test12() {
        String[] names = new String[]{"p0", "p1"};
        String module = "test12.js";
        int position = this.lastPositionInFile("p", module);
        this.basicTest(module, position, names);
    }

    public void test13() {
        String[] names = new String[]{"element"};
        String module = "test13.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test14() {
        String[] names = new String[]{"element"};
        String module = "test14.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test15() {
        String[] names = new String[]{};
        String module = "test15.js";
        int position = this.lastPositionInFile("firstVar.", module);
        this.basicTest(module, position, names);
    }

    public void test16() {
        String[] names = new String[]{"xaml"};
        String module = "test16.js";
        int position = this.lastPositionInFile("x", module);
        this.basicTest(module, position, names);
    }

    public void test17() {
        String[] names = new String[]{};
        String module = "test17.js";
        int position = this.lastPositionInFile("x", module);
        this.basicTest(module, position, names);
    }

    public void test18() {
        String[] names = new String[]{"my"};
        String module = "test18.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test19() {
        String[] names = new String[]{};
        String module = "test19.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test20() {
        String[] names = new String[]{"my"};
        String module = "test20.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test21() {
        String[] names = new String[]{"favorite"};
        String module = "test21.js";
        int position = this.lastPositionInFile("hello.my.", module);
        this.basicTest(module, position, names);
    }

    public void test22() {
        String[] names = new String[]{};
        String module = "test22.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test23() {
        String[] names = new String[]{"my", "olive"};
        String module = "test23.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test24() {
        String[] names = new String[]{"age", "wine"};
        String module = "test24.js";
        int position = this.lastPositionInFile("hello.olive.", module);
        this.basicTest(module, position, names);
    }

    public void test25() {
        String[] names = new String[]{"age", "my", "olive", "wine"};
        String module = "test25.js";
        int position = this.lastPositionInFile("hello.olive.", module);
        this.basicTest(module, position, names);
    }

    public void test26() {
        String[] names = new String[]{"wine"};
        String module = "test26.js";
        int position = this.lastPositionInFile("hello.olive.", module);
        this.basicTest(module, position, names);
    }

    public void test27() {
        String[] names = new String[]{"olive"};
        String module = "test27.js";
        int position = this.lastPositionInFile("hello.o", module);
        this.basicTest(module, position, names);
    }

    public void test28() {
        String[] names = new String[]{};
        String module = "test28.js";
        int position = this.lastPositionInFile("hello.", module);
        this.basicTest(module, position, names);
    }

    public void test29() {
        String[] names = new String[]{"x"};
        String module = "test29.js";
        int position = this.lastPositionInFile("{", module);
        this.basicTest(module, position, names);
    }

    public void test30() {
        String[] names = new String[]{"xsd"};
        String module = "test30.js";
        int position = this.lastPositionInFile("sz.", module);
        this.basicTest(module, position, names);
    }

    public void test31() {
        String[] names = new String[]{"x"};
        String module = "test31.js";
        int position = this.lastPositionInFile("node.", module);
        this.basicTest(module, position, names);
    }

    public void test32() {
        String[] names = new String[]{"x"};
        String module = "test32.js";
        int position = this.lastPositionInFile("node.", module);
        this.basicTest(module, position, names);
    }

    public void test33() {
        String[] names = new String[]{"object", "objectVariable"};
        String module = "test33.js";
        int position = this.lastPositionInFile("{", module);
        this.basicTest(module, position, names);
    }

    public void test34() {
        String[] names = new String[]{"x2"};
        String module = "test34.js";
        int position = this.lastPositionInFile("object.", module);
        this.basicTest(module, position, names);
    }

    public void test35() {
        String[] names = new String[]{"x"};
        String module = "test35.js";
        int position = this.lastPositionInFile("c.", module);
        this.basicTest(module, position, names);
    }

    public void test36() {
        String[] names = new String[]{"e"};
        String module = "test36.js";
        int position = this.lastPositionInFile("{", module);
        this.basicTest(module, position, names);
    }

    public void test37() {
        String[] names = new String[]{"forward", "hello", "object"};
        String module = "test37.js";
        int position = this.lastPositionInFile("{", module);
        this.basicTest(module, position, names);
    }

    public void test38() {
        String[] names = new String[]{"object"};
        String module = "test38.js";
        int position = this.lastPositionInFile("o", module);
        this.basicTest(module, position, names);
    }

    public void test39() {
        String[] names = new String[]{"er"};
        String module = "test39.js";
        int position = this.lastPositionInFile("eer.", module);
        this.basicTest(module, position, names);
    }

    public void test40() {
        String[] names = new String[]{"s"};
        String module = "test40.js";
        int position = this.lastPositionInFile("v.", module);
        this.basicTest(module, position, names);
    }

    public void test41() {
        String[] names = new String[]{"hello"};
        String module = "test41.js";
        int position = this.lastPositionInFile("er[0].", module);
        this.basicTest(module, position, names);
    }

    public void test42() {
        String[] names = new String[]{"Hello", "Mama"};
        String module = "test42.js";
        int position = this.lastPositionInFile("object.", module);
        this.basicTest(module, position, names);
    }

    public void test43() {
        String[] names = new String[]{};
        String module = "test43.js";
        int position = this.lastPositionInFile(";", module);
        this.basicTest(module, position, names);
    }

    public void test44() {
        String[] names = new String[]{"main"};
        String module = "test44.js";
        int position = this.lastPositionInFile("object.", module);
        this.basicTest(module, position, names);
    }

    public void REM_test45() {
        String[] names = new String[]{"word", "other_word"};
        String module = "test45.js";
        int position = this.lastPositionInFile("x.hello.", module);
        this.basicTest(module, position, names);
    }

    public void test46() {
        String[] names = new String[]{"aaa", "baa", "my", "prototype"};
        String module = "test46.js";
        int position = this.lastPositionInFile("x.", module);
        this.basicTest(module, position, names);
    }

    public void test47() {
        String[] names = new String[]{"x", "y"};
        String module = "test47.js";
        int position = this.lastPositionInFile("this.", module);
        this.basicTest(module, position, names);
    }

    public void REM_test48() {
        String[] names = new String[]{"erer"};
        String module = "test48.js";
        int position = this.lastPositionInFile("this.", module);
        this.basicTest(module, position, names);
    }

    private final class NullEnvironment
    implements ISearchableEnvironment {
        private NullEnvironment() {
        }

        public NameLookup getNameLookup() {
            return null;
        }

        public void cleanup() {
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            return false;
        }
    }

    private final class TestCompletionRequetor
    extends CompletionRequestor {
        LinkedList results;

        public TestCompletionRequetor(LinkedList results2) {
            this.results = results2;
        }

        public void accept(CompletionProposal proposal) {
            this.results.add(proposal);
        }
    }

    private final class TestModule
    extends ModelElement
    implements ISourceModule,
    org.eclipse.dltk.core.ISourceModule {
        String content;
        String elementName;

        public TestModule(String string) {
            super(null);
            this.content = string;
            this.elementName = "noname.js";
        }

        public TestModule(URL resource) {
            super(null);
            try {
                new StringBuffer();
                DataInputStream str = new DataInputStream(resource.openStream());
                this.elementName = new Path(resource.getPath()).lastSegment();
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                while (str.available() >= 0) {
                    int k = str.read();
                    if (k == -1) break;
                    bs.write(k);
                }
                this.content = new String(bs.toByteArray(), "UTF-8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException();
            }
        }

        public IModelElement getModelElement() {
            return null;
        }

        public IPath getScriptFolder() {
            return null;
        }

        public String getSourceContents() {
            return this.content;
        }

        public char[] getFileName() {
            return "".toCharArray();
        }

        public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        }

        public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        }

        public void discardWorkingCopy() throws ModelException {
        }

        public IModelElement getElementAt(int position) throws ModelException {
            return null;
        }

        public IField getField(String string) {
            return null;
        }

        public IField[] getFields() throws ModelException {
            return null;
        }

        public IMethod getMethod(String name) {
            return null;
        }

        public WorkingCopyOwner getOwner() {
            return null;
        }

        public IPackageDeclaration getPackageDeclaration(String name) {
            return null;
        }

        public IPackageDeclaration[] getPackageDeclarations() throws ModelException {
            return null;
        }

        public org.eclipse.dltk.core.ISourceModule getPrimary() {
            return null;
        }

        public String getSource() throws ModelException {
            return null;
        }

        public IType getType(String name) {
            return null;
        }

        public IType[] getTypes() throws ModelException {
            return null;
        }

        public org.eclipse.dltk.core.ISourceModule getWorkingCopy(IProgressMonitor monitor) throws ModelException {
            return null;
        }

        public org.eclipse.dltk.core.ISourceModule getWorkingCopy(WorkingCopyOwner owner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
            return null;
        }

        public boolean isPrimary() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isWorkingCopy() {
            return false;
        }

        public void reconcile(boolean forceProblemDetection, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        }

        public boolean exists() {
            return false;
        }

        public IModelElement getAncestor(int ancestorType) {
            return null;
        }

        public IResource getCorrespondingResource() throws ModelException {
            return null;
        }

        public String getElementName() {
            return this.elementName;
        }

        public int getElementType() {
            return 0;
        }

        public String getHandleIdentifier() {
            return null;
        }

        public IScriptModel getModel() {
            return null;
        }

        public IOpenable getOpenable() {
            return null;
        }

        public IModelElement getParent() {
            return null;
        }

        public IPath getPath() {
            return null;
        }

        public IModelElement getPrimaryElement() {
            return null;
        }

        public IResource getResource() {
            return null;
        }

        public IScriptProject getScriptProject() {
            return null;
        }

        public IResource getUnderlyingResource() throws ModelException {
            return null;
        }

        public boolean isStructureKnown() throws ModelException {
            return false;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IModelElement[] getChildren() throws ModelException {
            return null;
        }

        public boolean hasChildren() throws ModelException {
            return false;
        }

        public void close() throws ModelException {
        }

        public IBuffer getBuffer() throws ModelException {
            return null;
        }

        public boolean hasUnsavedChanges() throws ModelException {
            return false;
        }

        public boolean isConsistent() throws ModelException {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public void makeConsistent(IProgressMonitor progress) throws ModelException {
        }

        public void open(IProgressMonitor progress) throws ModelException {
        }

        public void save(IProgressMonitor progress, boolean force) throws ModelException {
        }

        public ISourceRange getSourceRange() throws ModelException {
            return null;
        }

        public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        }

        public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        }

        public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        }

        public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
        }

        public void codeComplete(int offset, CompletionRequestor requestor) throws ModelException {
        }

        public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
        }

        public IModelElement[] codeSelect(int offset, int length) throws ModelException {
            return null;
        }

        public IModelElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws ModelException {
            return null;
        }

        protected void closing(Object info) throws ModelException {
        }

        protected Object createElementInfo() {
            return null;
        }

        protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        }

        public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
            return null;
        }

        protected char getHandleMementoDelimiter() {
            return '\u0000';
        }

        public void printNode(CorePrinter output) {
        }

        public IType[] getAllTypes() throws ModelException {
            return null;
        }

        public char[] getSourceAsCharArray() throws ModelException {
            return null;
        }

        public boolean isBuiltin() {
            return false;
        }
    }
}

